/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv;

import com.couchbase.client.core.cnc.events.io.UnknownServerPushRequestReceivedEvent;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelInboundHandlerAdapter;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.topology.TopologyRevision;
import com.couchbase.client.core.util.CbStrings;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerPushHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(ServerPushHandler.class);
    private final EndpointContext endpointContext;

    public ServerPushHandler(EndpointContext endpointContext) {
        this.endpointContext = Objects.requireNonNull(endpointContext);
    }

    private static @Nullable TopologyRevision parseTopologyRevision(ByteBuf packet) {
        ByteBuf extras = MemcacheProtocol.extras(packet).orElse(Unpooled.EMPTY_BUFFER);
        switch (extras.readableBytes()) {
            case 4: {
                return new TopologyRevision(0L, extras.readUnsignedInt());
            }
            case 16: {
                return new TopologyRevision(extras.readLong(), extras.readLong());
            }
        }
        log.debug("Unexpected CLUSTERMAP_CHANGE_NOTIFICATION extras length: {}", (Object)extras.readableBytes());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf buf;
        if (msg instanceof ByteBuf && MemcacheProtocol.magic(buf = (ByteBuf)msg) == MemcacheProtocol.Magic.SERVER_PUSH_REQUEST.magic()) {
            try {
                byte opcodeByte = MemcacheProtocol.opcode(buf);
                MemcacheProtocol.ServerPushOpcode opcode = MemcacheProtocol.ServerPushOpcode.of(opcodeByte);
                if (opcode == MemcacheProtocol.ServerPushOpcode.CLUSTERMAP_CHANGE_NOTIFICATION) {
                    String bucketOrNullIfGlobal = CbStrings.emptyToNull(MemcacheProtocol.keyAsString(buf));
                    TopologyRevision newRevision = ServerPushHandler.parseTopologyRevision(buf);
                    this.endpointContext.core().configurationProvider().signalNewTopologyAvailable(bucketOrNullIfGlobal, newRevision);
                    return;
                }
                this.endpointContext.core().environment().eventBus().publish(new UnknownServerPushRequestReceivedEvent(null, ByteBufUtil.getBytes(buf)));
                return;
            }
            finally {
                buf.release();
            }
        }
        ctx.fireChannelRead(msg);
    }
}

