/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.channel.Channel;
import com.couchbase.client.core.deps.io.netty.channel.DefaultEventLoopGroup;
import com.couchbase.client.core.deps.io.netty.channel.EventLoopGroup;
import com.couchbase.client.core.deps.io.netty.channel.IoHandler;
import com.couchbase.client.core.deps.io.netty.channel.IoHandlerFactory;
import com.couchbase.client.core.deps.io.netty.channel.MultiThreadIoEventLoopGroup;
import com.couchbase.client.core.deps.io.netty.channel.epoll.Epoll;
import com.couchbase.client.core.deps.io.netty.channel.epoll.EpollIoHandler;
import com.couchbase.client.core.deps.io.netty.channel.epoll.EpollSocketChannel;
import com.couchbase.client.core.deps.io.netty.channel.kqueue.KQueue;
import com.couchbase.client.core.deps.io.netty.channel.kqueue.KQueueIoHandler;
import com.couchbase.client.core.deps.io.netty.channel.kqueue.KQueueSocketChannel;
import com.couchbase.client.core.deps.io.netty.channel.local.LocalChannel;
import com.couchbase.client.core.deps.io.netty.channel.local.LocalIoHandler;
import com.couchbase.client.core.deps.io.netty.channel.nio.NioIoHandler;
import com.couchbase.client.core.deps.io.netty.channel.socket.nio.NioSocketChannel;

@Stability.Internal
public class EventLoopGroups {
    private EventLoopGroups() {
    }

    public static IoHandlerFactory newIoHandlerFactory(boolean nativeIoEnabled) {
        if (nativeIoEnabled && Epoll.isAvailable()) {
            return EpollIoHandler.newFactory();
        }
        if (nativeIoEnabled && KQueue.isAvailable()) {
            return KQueueIoHandler.newFactory();
        }
        return NioIoHandler.newFactory();
    }

    public static Class<? extends Channel> channelType(EventLoopGroup eventLoopGroup) {
        if (EventLoopGroups.isEpoll(eventLoopGroup)) {
            return EpollSocketChannel.class;
        }
        if (EventLoopGroups.isNio(eventLoopGroup)) {
            return NioSocketChannel.class;
        }
        if (EventLoopGroups.isKQueue(eventLoopGroup)) {
            return KQueueSocketChannel.class;
        }
        if (EventLoopGroups.isLocal(eventLoopGroup)) {
            return LocalChannel.class;
        }
        throw new IllegalArgumentException("Unknown EventLoopGroup Type: " + eventLoopGroup.getClass().getSimpleName());
    }

    public static boolean isKQueue(EventLoopGroup group) {
        return EventLoopGroups.isIoType(group, KQueueIoHandler.class);
    }

    public static boolean isEpoll(EventLoopGroup group) {
        return EventLoopGroups.isIoType(group, EpollIoHandler.class);
    }

    public static boolean isNio(EventLoopGroup group) {
        return EventLoopGroups.isIoType(group, NioIoHandler.class);
    }

    public static boolean isLocal(EventLoopGroup group) {
        return EventLoopGroups.isIoType(group, LocalIoHandler.class) || group instanceof DefaultEventLoopGroup;
    }

    private static boolean isIoType(EventLoopGroup group, Class<? extends IoHandler> handlerType) {
        return group instanceof MultiThreadIoEventLoopGroup && ((MultiThreadIoEventLoopGroup)group).isIoType(handlerType);
    }
}

