/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.util.CbStrings;
import java.util.Objects;

@Stability.Volatile
public class BucketNotFoundException
extends CouchbaseException {
    private final String bucketName;

    public BucketNotFoundException(String bucketName) {
        this(bucketName, (ErrorContext)null);
    }

    public BucketNotFoundException(String bucketName, ErrorContext errorContext) {
        super("Bucket" + BucketNotFoundException.formatCollection(bucketName) + " not found.", errorContext);
        this.bucketName = Objects.requireNonNull(bucketName);
    }

    private static String formatCollection(String collectionName) {
        return CbStrings.isNullOrEmpty(collectionName) ? "" : " [" + RedactableArgument.redactMeta(collectionName) + "]";
    }

    public static BucketNotFoundException forBucket(String bucketName) {
        return new BucketNotFoundException(bucketName);
    }

    public String bucketName() {
        return this.bucketName;
    }
}

