/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.tracing;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.tracing.ObservabilitySemanticConvention;
import com.couchbase.client.core.cnc.tracing.TracingAttribute;
import com.couchbase.client.core.cnc.tracing.TracingDecoratorImpl;
import com.couchbase.client.core.cnc.tracing.TracingDecoratorImplV0;
import com.couchbase.client.core.cnc.tracing.TracingDecoratorImplV1;
import java.util.List;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class TracingDecorator {
    private final TracingDecoratorImpl v0 = new TracingDecoratorImplV0();
    private final TracingDecoratorImpl v1 = new TracingDecoratorImplV1();
    private final boolean useV0;
    private final boolean useV1;

    public TracingDecorator(List<ObservabilitySemanticConvention> conventions) {
        if (conventions.isEmpty()) {
            this.useV0 = true;
            this.useV1 = false;
        } else if (conventions.contains((Object)ObservabilitySemanticConvention.DATABASE_DUP)) {
            this.useV0 = true;
            this.useV1 = true;
        } else if (conventions.contains((Object)ObservabilitySemanticConvention.DATABASE)) {
            this.useV0 = false;
            this.useV1 = true;
        } else {
            throw new IllegalArgumentException("Unknown observability convention: " + conventions);
        }
    }

    public void provideAttr(TracingAttribute attribute, RequestSpan span, String value) {
        if (this.useV0) {
            this.v0.provideAttr(attribute, span, value);
        }
        if (this.useV1) {
            this.v1.provideAttr(attribute, span, value);
        }
    }

    public void provideAttr(TracingAttribute attribute, RequestSpan span, long value) {
        if (this.useV0) {
            this.v0.provideAttr(attribute, span, value);
        }
        if (this.useV1) {
            this.v1.provideAttr(attribute, span, value);
        }
    }

    public void provideAttr(TracingAttribute attribute, RequestSpan span, boolean value) {
        if (this.useV0) {
            this.v0.provideAttr(attribute, span, value);
        }
        if (this.useV1) {
            this.v1.provideAttr(attribute, span, value);
        }
    }

    public void provideLowCardinalityAttr(TracingAttribute attribute, RequestSpan span, String value) {
        if (this.useV0) {
            this.v0.provideLowCardinalityAttr(attribute, span, value);
        }
        if (this.useV1) {
            this.v1.provideLowCardinalityAttr(attribute, span, value);
        }
    }

    public void provideQueryStatementIfSafe(TracingAttribute attribute, RequestSpan span, String value, boolean parametersUsed) {
        if (this.useV0) {
            this.v0.provideAttr(attribute, span, value);
        }
        if (this.useV1 && parametersUsed) {
            this.v1.provideAttr(attribute, span, value);
        }
    }

    public void provideCommonDispatchSpanAttributes(RequestSpan span, @Nullable String localId, @Nullable String localHost, int localPort, @Nullable String remoteCanonicalHost, int remoteCanonicalPort, @Nullable String remoteActualHost, int remoteActualPort, @Nullable String operationId) {
        if (this.useV0) {
            this.v0.provideCommonDispatchSpanAttributes(span, localId, localHost, localPort, remoteCanonicalHost, remoteCanonicalPort, remoteActualHost, remoteActualPort, operationId);
        }
        if (this.useV1) {
            this.v1.provideCommonDispatchSpanAttributes(span, localId, localHost, localPort, remoteCanonicalHost, remoteCanonicalPort, remoteActualHost, remoteActualPort, operationId);
        }
    }

    public void provideManagerOrActualService(RequestSpan span, String actualService) {
        if (this.useV0) {
            this.v0.provideLowCardinalityAttr(TracingAttribute.SERVICE, span, this.v0.managerOrActualService(actualService));
        }
        if (this.useV1) {
            this.v1.provideLowCardinalityAttr(TracingAttribute.SERVICE, span, this.v1.managerOrActualService(actualService));
        }
    }
}

