/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.tracing;

import com.couchbase.client.core.annotation.Stability;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stability.Uncommitted
public enum ObservabilitySemanticConvention {
    DATABASE,
    DATABASE_DUP;

    private static final Logger LOGGER;
    private static final List<String> RECOGNIZED_VALUES;

    public static List<ObservabilitySemanticConvention> loadAndParseOpenTelemetryEnvVar() {
        String otelEnvVar = System.getProperty("OTEL_SEMCONV_STABILITY_OPT_IN", null);
        if (otelEnvVar == null) {
            return new ArrayList<ObservabilitySemanticConvention>();
        }
        List<ObservabilitySemanticConvention> out = Arrays.stream(otelEnvVar.split(",")).map(String::trim).filter(s -> {
            if (!RECOGNIZED_VALUES.contains(s)) {
                LOGGER.warn("Did not recognize OTEL_SEMCONV_STABILITY_OPT_IN value '{}', item '{}': error '{}'.  Recognized values are from the set {}, in a comma-separated list.", new Object[]{otelEnvVar, s, s, RECOGNIZED_VALUES});
                return false;
            }
            return true;
        }).map(String::toUpperCase).map(s -> s.replace('/', '_')).map(s -> {
            try {
                return ObservabilitySemanticConvention.valueOf(s);
            }
            catch (RuntimeException e) {
                LOGGER.warn("Did not recognize OTEL_SEMCONV_STABILITY_OPT_IN value '{}' item '{}': error '{}'.  Recognized values are from the set {}, in a comma-separated list.", new Object[]{otelEnvVar, s, e.toString(), RECOGNIZED_VALUES});
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        LOGGER.info("Found semantic convention OTEL_SEMCONV_STABILITY_OPT_IN '{}', parsed as: {}", (Object)otelEnvVar, out);
        return out;
    }

    static {
        LOGGER = LoggerFactory.getLogger(ObservabilitySemanticConvention.class);
        RECOGNIZED_VALUES = Collections.unmodifiableList(Arrays.stream(ObservabilitySemanticConvention.values()).map(v -> v.name().toLowerCase(Locale.ROOT).replace('_', '/')).collect(Collectors.toList()));
    }
}

