/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.result;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;

@Stability.Internal
@JsonIgnoreProperties(ignoreUnknown=true)
public class CoreSearchTermRange {
    private final String name;
    private final long count;

    @JsonCreator
    public CoreSearchTermRange(@JsonProperty(value="term") String name, @JsonProperty(value="count") long count) {
        this.name = name;
        this.count = count;
    }

    public String name() {
        return this.name;
    }

    public long count() {
        return this.count;
    }

    public String toString() {
        return "{name='" + this.name + '\'' + ", count=" + this.count + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreSearchTermRange termRange = (CoreSearchTermRange)o;
        if (this.count != termRange.count) {
            return false;
        }
        return this.name.equals(termRange.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (int)(this.count ^ this.count >>> 32);
        return result;
    }
}

