/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.search.v1.DocIdQuery;
import com.couchbase.client.protostellar.search.v1.Query;
import java.util.List;

@Stability.Internal
public class CoreDocIdQuery
extends CoreSearchQuery {
    private final List<String> docIds;

    public CoreDocIdQuery(Double boost, List<String> docIds) {
        super(boost);
        this.docIds = Validators.notNullOrEmpty(docIds, "Document IDs");
    }

    @Override
    protected void injectParams(ObjectNode input) {
        ArrayNode ids = Mapper.createArrayNode();
        this.docIds.forEach(ids::add);
        input.set("ids", ids);
    }

    @Override
    public Query asProtostellar() {
        DocIdQuery.Builder builder = DocIdQuery.newBuilder().addAllIds(this.docIds);
        if (this.boost != null) {
            builder.setBoost(this.boost.floatValue());
        }
        return Query.newBuilder().setDocIdQuery(builder).build();
    }
}

