/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.forwards;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.transaction.forwards.CoreTransactionsSupportedExtensions;
import com.couchbase.client.core.transaction.forwards.ForwardCompatBehaviourFull;
import com.couchbase.client.core.transaction.forwards.ForwardCompatRequirement;
import java.util.Objects;

@Stability.Internal
class ForwardCompatProtocolRequirement
extends ForwardCompatRequirement {
    public final int minProtocolMajor;
    public final int minProtocolMinor;

    ForwardCompatProtocolRequirement(JsonNode json) {
        super(Objects.requireNonNull(json));
        String protocolVersion = json.path("p").textValue();
        String[] split = protocolVersion.split("\\.");
        this.minProtocolMajor = Integer.parseInt(split[0]);
        this.minProtocolMinor = Integer.parseInt(split[1]);
    }

    @Override
    public ForwardCompatBehaviourFull behaviour(CoreTransactionsSupportedExtensions supported) {
        if (supported.protocolMajor() > this.minProtocolMajor) {
            return ForwardCompatBehaviourFull.CONTINUE;
        }
        if (supported.protocolMajor() < this.minProtocolMajor) {
            return this.behaviour;
        }
        if (supported.protocolMinor() < this.minProtocolMinor) {
            return this.behaviour;
        }
        return ForwardCompatBehaviourFull.CONTINUE;
    }
}

