/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.cleanup;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreSubdocGetResult;
import com.couchbase.client.core.cnc.tracing.RequestTracerAndDecorator;
import com.couchbase.client.core.cnc.tracing.TracingAttribute;
import com.couchbase.client.core.cnc.tracing.TracingDecorator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.core.msg.kv.SubdocCommandType;
import com.couchbase.client.core.msg.kv.SubdocGetRequest;
import com.couchbase.client.core.msg.kv.SubdocMutateRequest;
import com.couchbase.client.core.retry.reactor.Retry;
import com.couchbase.client.core.transaction.CoreTransactionsReactive;
import com.couchbase.client.core.transaction.cleanup.AccessErrorException;
import com.couchbase.client.core.transaction.cleanup.ClientRecordDetails;
import com.couchbase.client.core.transaction.components.ActiveTransactionRecord;
import com.couchbase.client.core.transaction.config.CoreTransactionsConfig;
import com.couchbase.client.core.transaction.error.internal.ErrorClass;
import com.couchbase.client.core.transaction.support.OptionsUtil;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.core.transaction.support.SpanWrapperUtil;
import com.couchbase.client.core.transaction.util.DebugUtil;
import com.couchbase.client.core.transaction.util.TransactionKVHandler;
import com.couchbase.client.core.util.Bytes;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ClientRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"com.couchbase.transactions.clientrecord");
    private final Core core;
    public static final String CLIENT_RECORD_DOC_ID = "_txn:client-record";
    private static final String FIELD_HEARTBEAT = "heartbeat_ms";
    private static final String FIELD_EXPIRES = "expires_ms";
    private static final String FIELD_NUM_ATRS = "num_atrs";
    private static final String FIELD_HOST = "host";
    private static final String FIELD_IMPLEMENTATION = "implementation";
    private static final String FIELD_VERSION = "version";
    private static final String FIELD_PROCESS_ID = "process_id";
    public static final String FIELD_RECORDS = "records";
    public static final String FIELD_CLIENTS = "clients";
    public static final String FIELD_OVERRIDE = "override";
    public static final String FIELD_OVERRIDE_ENABLED = "enabled";
    public static final String FIELD_OVERRIDE_EXPIRES = "expires";
    private static final int SAFETY_MARGIN_EXPIRY_MILLIS = 20000;
    private static final Duration TIMEOUT = Duration.ofMillis(500L);
    private static final Duration BACKOFF_START = Duration.ofMillis(10L);
    private static final Duration BACKOFF_END = Duration.ofMillis(250L);

    public ClientRecord(Core core) {
        this.core = Objects.requireNonNull(core);
    }

    public Flux<Void> removeClientFromClientRecord(String clientUuid, Set<CollectionIdentifier> cleanupSet) {
        return this.removeClientFromClientRecord(clientUuid, TIMEOUT, cleanupSet);
    }

    public Flux<Void> removeClientFromClientRecord(String clientUuid, Duration timeout, Set<CollectionIdentifier> collections) {
        return Flux.fromIterable(collections).subscribeOn(this.core.context().environment().transactionsSchedulers().schedulerCleanup()).doOnNext(v -> LOGGER.info("{} removing from client record on collection {}", (Object)clientUuid, (Object)RedactableArgument.redactUser(v))).concatMap(collection -> this.beforeRemoveClient(this).then(TransactionKVHandler.mutateIn(this.core, collection, CLIENT_RECORD_DOC_ID, this.mutatingTimeout(), false, false, false, false, false, 0L, CodecFlags.BINARY_COMMON_FLAGS, Optional.empty(), OptionsUtil.createClientContext("Cleaner::removeClientFromCleanupSet"), null, Arrays.asList(new SubdocMutateRequest.Command(SubdocCommandType.DELETE, "records.clients." + clientUuid, Bytes.EMPTY_BYTE_ARRAY, false, true, false, 0)))).onErrorResume(err -> {
            switch (ErrorClass.classify(err)) {
                case FAIL_DOC_NOT_FOUND: {
                    LOGGER.info("{}/{} remove skipped as client record does not exist", (Object)RedactableArgument.redactUser(collection), (Object)clientUuid);
                    return Mono.empty();
                }
                case FAIL_PATH_NOT_FOUND: {
                    LOGGER.info("{}/{} remove skipped as client record entry does not exist", (Object)RedactableArgument.redactUser(collection), (Object)clientUuid);
                    return Mono.empty();
                }
            }
            LOGGER.info("{}/{} got error while removing client from client record: {}", new Object[]{RedactableArgument.redactUser(collection), clientUuid, DebugUtil.dbg(err)});
            return Mono.error((Throwable)err);
        }).retryWhen(Retry.any().exponentialBackoff(BACKOFF_START, BACKOFF_END).doOnRetry(v -> LOGGER.info("{}/{} retrying removing client from record on error {}", new Object[]{RedactableArgument.redactUser(collection), clientUuid, DebugUtil.dbg(v.exception())})).toReactorRetry()).timeout(timeout).doOnNext(v -> LOGGER.info("{}/{} removed from client record", (Object)RedactableArgument.redactUser(collection), (Object)clientUuid)).doOnError(err -> LOGGER.info("got error while removing client record '{}'", (Object)String.valueOf(err))).then());
    }

    private Duration mutatingTimeout() {
        return this.core.context().environment().timeoutConfig().kvDurableTimeout();
    }

    private Duration nonMutatingTimeout() {
        return this.core.context().environment().timeoutConfig().kvTimeout();
    }

    public static ClientRecordDetails parseClientRecord(CoreSubdocGetResult clientRecord, String clientUuid) {
        try {
            JsonNode records = Mapper.reader().readValue(clientRecord.field(0).value(), JsonNode.class);
            JsonNode hlcRaw = Mapper.reader().readValue(clientRecord.field(1).value(), JsonNode.class);
            ActiveTransactionRecord.ParsedHLC parsedHLC = new ActiveTransactionRecord.ParsedHLC(hlcRaw);
            JsonNode clients = records.get(FIELD_CLIENTS);
            ArrayList<String> expiredClientIds = new ArrayList<String>();
            ArrayList<String> activeClientIds = new ArrayList<String>();
            Iterator<String> iterator = clients.fieldNames();
            while (iterator.hasNext()) {
                boolean out;
                int expiresMsecs;
                long heartbeatMillis;
                String otherClientId = iterator.next();
                JsonNode cl = clients.get(otherClientId);
                long casMillis = parsedHLC.nowInNanos() / 1000000L;
                long expiredPeriod = casMillis - (heartbeatMillis = ActiveTransactionRecord.parseMutationCAS(cl.get(FIELD_HEARTBEAT).textValue()));
                boolean hasExpired = expiredPeriod >= (long)(expiresMsecs = cl.get(FIELD_EXPIRES).intValue());
                boolean bl = out = hasExpired && !otherClientId.equals(clientUuid);
                if (out) {
                    expiredClientIds.add(otherClientId);
                    continue;
                }
                activeClientIds.add(otherClientId);
            }
            if (!activeClientIds.contains(clientUuid)) {
                activeClientIds.add(clientUuid);
            }
            List sortedActiveClientIds = activeClientIds.stream().sorted().collect(Collectors.toList());
            int indexOfThisClient = sortedActiveClientIds.indexOf(clientUuid);
            int numExpiredClients = expiredClientIds.size();
            int numActiveClients = sortedActiveClientIds.size();
            int numExistingClients = numExpiredClients + numActiveClients;
            boolean alreadyContainsClient = clients.has(clientUuid);
            boolean overrideEnabled = false;
            long overrideExpiresCas = 0L;
            JsonNode override = records.get(FIELD_OVERRIDE);
            if (override != null) {
                overrideEnabled = override.get(FIELD_OVERRIDE_ENABLED).asBoolean();
                overrideExpiresCas = override.get(FIELD_OVERRIDE_EXPIRES).asLong();
            }
            return new ClientRecordDetails(numActiveClients, indexOfThisClient, !alreadyContainsClient, expiredClientIds, numExistingClients, numExpiredClients, overrideEnabled, overrideExpiresCas, parsedHLC.nowInNanos());
        }
        catch (IOException e) {
            throw new DecodingFailureException(e);
        }
    }

    public Mono<CoreSubdocGetResult> getClientRecord(CollectionIdentifier collection, @Nullable SpanWrapper span) {
        return TransactionKVHandler.lookupIn(this.core, collection, CLIENT_RECORD_DOC_ID, this.nonMutatingTimeout(), false, OptionsUtil.createClientContext("ClientRecord::getClientRecord"), span, false, Arrays.asList(new SubdocGetRequest.Command(SubdocCommandType.GET, FIELD_RECORDS, true, 0), new SubdocGetRequest.Command(SubdocCommandType.GET, "$vbucket.HLC", true, 1)));
    }

    private RequestTracerAndDecorator tracer() {
        return this.core.context().coreResources().requestTracerAndDecorator();
    }

    private TracingDecorator tracingDecorator() {
        return this.core.context().coreResources().tracingDecorator();
    }

    public Mono<ClientRecordDetails> processClient(String clientUuid, CollectionIdentifier collection, CoreTransactionsConfig config, @Nullable SpanWrapper pspan) {
        return Mono.defer(() -> {
            SpanWrapper span = SpanWrapperUtil.createOp(null, this.tracer(), collection, CLIENT_RECORD_DOC_ID, "transaction_cleanup_client", pspan);
            this.tracingDecorator().provideAttr(TracingAttribute.TRANSACTION_CLEANUP_CLIENT_ID, span.span(), clientUuid);
            String bp = collection.bucket() + "/" + collection.scope().orElse("-") + "/" + collection.collection().orElse("-") + "/" + clientUuid;
            return this.beforeGetRecord(this).then(this.getClientRecord(collection, span)).flatMap(clientRecord -> {
                ClientRecordDetails cr = ClientRecord.parseClientRecord(clientRecord, clientUuid);
                LOGGER.debug("{} found {} existing clients including this ({} active, {} expired), included this={}, index of this={}, override={enabled={},expires={},now={},active={}}", new Object[]{bp, cr.numExistingClients(), cr.numActiveClients(), cr.numExpiredClients(), !cr.clientIsNew(), cr.indexOfThisClient(), cr.overrideEnabled(), cr.overrideExpires(), cr.casNow(), cr.overrideActive()});
                if (cr.overrideActive()) {
                    return Mono.just((Object)cr);
                }
                ArrayList<SubdocMutateRequest.Command> specs = new ArrayList<SubdocMutateRequest.Command>();
                String field = "records.clients." + clientUuid;
                String host = "unavailable";
                try {
                    host = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                long pid = 0L;
                String name = ManagementFactory.getRuntimeMXBean().getName();
                try {
                    pid = Long.parseLong(name.split("@")[0]);
                }
                catch (Throwable err) {
                    LOGGER.debug("Discarding error {} while trying to parse PID {}", (Object)err.getMessage(), (Object)name);
                }
                byte[] toWrite = Mapper.encodeAsBytes(Mapper.createObjectNode().put(FIELD_EXPIRES, config.cleanupConfig().cleanupWindow().toMillis() + 20000L).put(FIELD_NUM_ATRS, config.numAtrs()).put(FIELD_IMPLEMENTATION, "java").put(FIELD_VERSION, CoreTransactionsReactive.class.getPackage().getImplementationVersion()).put(FIELD_HOST, host).put(FIELD_PROCESS_ID, pid));
                specs.add(new SubdocMutateRequest.Command(SubdocCommandType.DICT_UPSERT, field, toWrite, true, true, false, 0));
                try {
                    specs.add(new SubdocMutateRequest.Command(SubdocCommandType.DICT_UPSERT, field + "." + FIELD_HEARTBEAT, Mapper.writer().writeValueAsBytes("${Mutation.CAS}"), false, true, true, 1));
                }
                catch (JsonProcessingException e) {
                    throw new EncodingFailureException(e);
                }
                cr.expiredClientIds().stream().limit(16 - specs.size() - 1).forEach(expiredClientId -> {
                    LOGGER.debug("{} removing expired client {}", (Object)bp, expiredClientId);
                    specs.add(new SubdocMutateRequest.Command(SubdocCommandType.DELETE, "records.clients." + expiredClientId, null, false, true, false, specs.size()));
                });
                specs.add(new SubdocMutateRequest.Command(SubdocCommandType.SET_DOC, "", new byte[]{0}, false, false, false, specs.size()));
                return this.beforeUpdateRecord(this).then(TransactionKVHandler.mutateIn(this.core, collection, CLIENT_RECORD_DOC_ID, this.mutatingTimeout(), false, false, false, false, false, 0L, CodecFlags.BINARY_COMMON_FLAGS, Optional.empty(), OptionsUtil.createClientContext("ClientRecord::processClient"), span, specs)).thenReturn((Object)cr);
            }).onErrorResume(err -> {
                ErrorClass ec = ErrorClass.classify(err);
                LOGGER.debug("{} got error processing client record: {}", (Object)bp, (Object)DebugUtil.dbg(err));
                if (ec == ErrorClass.FAIL_DOC_NOT_FOUND) {
                    return this.createClientRecord(clientUuid, collection, span).then(this.processClient(clientUuid, collection, config, pspan));
                }
                if (err instanceof CouchbaseException && ((CouchbaseException)err).context() != null && ((CouchbaseException)err).context().responseStatus() == ResponseStatus.NO_ACCESS) {
                    return Mono.error((Throwable)new AccessErrorException());
                }
                return Mono.error((Throwable)err);
            }).doOnError(err -> span.finish((Throwable)err)).doOnTerminate(() -> span.finish());
        });
    }

    private Mono<Void> createClientRecord(String clientUuid, CollectionIdentifier collection, SpanWrapper pspan) {
        String bp = collection.bucket() + "/" + collection.scope().orElse("-") + "/" + collection.collection().orElse("-") + "/" + clientUuid;
        return this.beforeCreateRecord(this).then(TransactionKVHandler.mutateIn(this.core, collection, CLIENT_RECORD_DOC_ID, this.mutatingTimeout(), true, false, false, false, false, 0L, CodecFlags.BINARY_COMMON_FLAGS, Optional.empty(), OptionsUtil.createClientContext("ClientRecord::createClientRecord"), pspan, Arrays.asList(new SubdocMutateRequest.Command(SubdocCommandType.DICT_ADD, "records.clients", "{}".getBytes(StandardCharsets.UTF_8), false, true, false, 0), new SubdocMutateRequest.Command(SubdocCommandType.SET_DOC, "", new byte[]{0}, false, false, false, 1)))).doOnSubscribe(v -> LOGGER.debug("{} found client record does not exist, creating and retrying", (Object)bp)).onErrorResume(e -> {
            if (ErrorClass.FAIL_DOC_ALREADY_EXISTS == ErrorClass.classify(e)) {
                LOGGER.debug("{} found client record exists after retry, another client must have created it, continuing", (Object)bp);
                return Mono.empty();
            }
            if (e instanceof CouchbaseException && ((CouchbaseException)e).context().responseStatus() == ResponseStatus.NO_ACCESS) {
                return Mono.error((Throwable)new AccessErrorException());
            }
            LOGGER.info("got error while creating client record '{}'", (Object)String.valueOf(e));
            return Mono.error((Throwable)e);
        }).then();
    }

    protected Mono<Integer> beforeCreateRecord(ClientRecord self) {
        return Mono.just((Object)1);
    }

    protected Mono<Integer> beforeRemoveClient(ClientRecord self) {
        return Mono.just((Object)1);
    }

    @Deprecated
    protected Mono<Integer> beforeUpdateCAS(ClientRecord self) {
        return Mono.just((Object)1);
    }

    protected Mono<Integer> beforeGetRecord(ClientRecord self) {
        return Mono.just((Object)1);
    }

    protected Mono<Integer> beforeUpdateRecord(ClientRecord self) {
        return Mono.just((Object)1);
    }
}

