/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreExpiry;
import com.couchbase.client.core.api.kv.CoreSubdocGetResult;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.core.transaction.components.DocumentMetadata;
import com.couchbase.client.core.transaction.components.TransactionLinks;
import com.couchbase.client.core.transaction.forwards.ForwardCompatibility;
import com.couchbase.client.core.transaction.util.DebugUtil;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreTransactionGetResult {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    @Nullable
    private final TransactionLinks links;
    private final Optional<DocumentMetadata> documentMetadata;
    private final Optional<String> crc32OfGet;
    private byte[] content;
    private long cas;
    private final String id;
    private final CollectionIdentifier collection;
    private final Optional<JsonNode> txnMeta;
    private final int userFlags;

    @Stability.Internal
    public CoreTransactionGetResult(String id, @Nullable byte[] content, int userFlags, long cas, CollectionIdentifier collection, @Nullable TransactionLinks links, Optional<DocumentMetadata> documentMetadata, Optional<JsonNode> txnMeta, Optional<String> crc32OfGet) {
        this.id = Objects.requireNonNull(id);
        this.content = content;
        this.userFlags = userFlags;
        this.cas = cas;
        this.collection = Objects.requireNonNull(collection);
        this.links = links;
        this.documentMetadata = Objects.requireNonNull(documentMetadata);
        this.txnMeta = Objects.requireNonNull(txnMeta);
        this.crc32OfGet = Objects.requireNonNull(crc32OfGet);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransactionGetResultInternal{");
        sb.append("id=").append(DebugUtil.docId(this.collection, this.id));
        sb.append(",userFlags=").append(this.userFlags);
        sb.append(",cas=").append(this.cas);
        sb.append(",bucket=").append(this.collection.bucket());
        sb.append(",scope=").append(this.collection.scope());
        sb.append(",coll=").append(this.collection.collection());
        sb.append(",links=").append(this.links);
        sb.append(",txnMeta=").append(this.txnMeta);
        sb.append('}');
        return sb.toString();
    }

    public Optional<DocumentMetadata> documentMetadata() {
        return this.documentMetadata;
    }

    @Nullable
    public TransactionLinks links() {
        return this.links;
    }

    Optional<JsonNode> txnMeta() {
        return this.txnMeta;
    }

    public String id() {
        return this.id;
    }

    public long cas() {
        return this.cas;
    }

    @Stability.Uncommitted
    public byte[] contentAsBytes() {
        return this.content;
    }

    CoreTransactionGetResult cas(long cas) {
        this.cas = cas;
        return this;
    }

    public Optional<String> crc32OfGet() {
        return this.crc32OfGet;
    }

    public boolean isBinary() {
        return this.links.stagedContentBinary().isPresent();
    }

    public boolean isInTransaction(String transactionId) {
        return this.links != null && this.links.stagedTransactionId().isPresent() && this.links.stagedTransactionId().get().equals(transactionId);
    }

    public boolean isInTransaction() {
        return this.links != null && this.links.isDocumentInTransaction();
    }

    @Stability.Internal
    static CoreTransactionGetResult createFromInsert(CollectionIdentifier collection, String id, byte[] content, int flagsToStage, String transactionId, String attemptId, String atrId, String atrBucketName, String atrScopeName, String atrCollectionName, long cas, Optional<CoreExpiry> expiry) {
        TransactionLinks links = new TransactionLinks(CodecFlags.extractCommonFormatFlags(flagsToStage) == CodecFlags.CommonFlags.JSON.ordinal() ? Optional.of(content) : Optional.empty(), CodecFlags.extractCommonFormatFlags(flagsToStage) == CodecFlags.CommonFlags.BINARY.ordinal() ? Optional.of(content) : Optional.empty(), Optional.ofNullable(atrId), Optional.ofNullable(atrBucketName), Optional.ofNullable(atrScopeName), Optional.ofNullable(atrCollectionName), Optional.of(transactionId), Optional.of(attemptId), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of("insert"), true, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(flagsToStage), expiry);
        return new CoreTransactionGetResult(id, content, flagsToStage, cas, collection, links, Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Stability.Internal
    public static CoreTransactionGetResult createFrom(CoreTransactionGetResult doc, byte[] content) {
        TransactionLinks links = new TransactionLinks(doc.links.stagedContentJson(), doc.links.stagedContentBinary(), doc.links.atrId(), doc.links.atrBucketName(), doc.links.atrScopeName(), doc.links.atrCollectionName(), doc.links.stagedTransactionId(), doc.links.stagedAttemptId(), doc.links.casPreTxn(), doc.links.revidPreTxn(), doc.links.exptimePreTxn(), doc.links.op(), doc.links.isDeleted(), doc.links.crc32OfStaging(), doc.links.forwardCompatibility(), doc.links.stagedOperationId(), doc.links.stagedUserFlags(), doc.links.stagedExpiry());
        return new CoreTransactionGetResult(doc.id, content, doc.userFlags, doc.cas, doc.collection, links, doc.documentMetadata, Optional.empty(), doc.crc32OfGet);
    }

    @Stability.Internal
    public static CoreTransactionGetResult createFrom(CollectionIdentifier collection, String documentId, CoreSubdocGetResult doc) throws IOException {
        JsonNode restore;
        Optional<String> atrId = Optional.empty();
        Optional<String> transactionId = Optional.empty();
        Optional<String> attemptId = Optional.empty();
        Optional<String> operationId = Optional.empty();
        Optional<byte[]> stagedContentJson = Optional.empty();
        Optional<byte[]> stagedContentBinary = Optional.empty();
        Optional<String> atrBucketName = Optional.empty();
        Optional<String> atrScopeName = Optional.empty();
        Optional<String> atrCollectionName = Optional.empty();
        Optional<String> crc32OfStaging = Optional.empty();
        Optional<ForwardCompatibility> forwardCompatibility = Optional.empty();
        Optional<Integer> stagedUserFlags = Optional.empty();
        Optional<CoreExpiry> stagedExpiry = Optional.empty();
        Optional<String> casPreTxn = Optional.empty();
        Optional<String> revidPreTxn = Optional.empty();
        Optional<Long> exptimePreTxn = Optional.empty();
        Optional<String> op = Optional.empty();
        if (doc.field(0).status().success()) {
            JsonNode id = MAPPER.readValue(doc.field(0).value(), JsonNode.class);
            transactionId = Optional.ofNullable(id.path("txn").textValue());
            attemptId = Optional.ofNullable(id.path("atmpt").textValue());
            operationId = Optional.ofNullable(id.path("op").textValue());
        }
        if (doc.field(1).status().success()) {
            JsonNode atr = MAPPER.readValue(doc.field(1).value(), JsonNode.class);
            atrId = Optional.ofNullable(atr.path("id").textValue());
            atrBucketName = Optional.ofNullable(atr.path("bkt").textValue());
            String scope = atr.path("scp").textValue();
            String coll = atr.path("coll").textValue();
            if (scope != null) {
                atrScopeName = Optional.ofNullable(scope);
                atrCollectionName = Optional.ofNullable(coll);
            } else {
                String[] splits = coll.split("\\.");
                atrScopeName = Optional.of(splits[0]);
                atrCollectionName = Optional.of(splits[1]);
            }
        }
        if (doc.field(2).status().success()) {
            op = Optional.of(Mapper.reader().readValue(doc.field(2).value(), String.class));
        }
        if (doc.field(3).status().success()) {
            byte[] raw = doc.field(3).value();
            stagedContentJson = Optional.of(raw);
        }
        if (doc.field(4).status().success()) {
            crc32OfStaging = Optional.of(Mapper.reader().readValue(doc.field(4).value(), String.class));
        }
        if (doc.field(5).status().success()) {
            restore = MAPPER.readValue(doc.field(5).value(), JsonNode.class);
            casPreTxn = Optional.of(restore.path("CAS").textValue());
            revidPreTxn = Optional.of(restore.path("revid").textValue());
            exptimePreTxn = Optional.of(restore.path("exptime").asLong());
        }
        if (doc.field(6).status().success()) {
            JsonNode json = MAPPER.readValue(doc.field(6).value(), JsonNode.class);
            ForwardCompatibility fc = new ForwardCompatibility(json);
            forwardCompatibility = Optional.of(fc);
        }
        if (!doc.field(7).status().success()) {
            throw new IllegalStateException("$document requested but not received");
        }
        restore = MAPPER.readValue(doc.field(7).value(), JsonNode.class);
        String casFromDocument = restore.path("CAS").textValue();
        String revidFromDocument = restore.path("revid").textValue();
        Long exptimeFromDocument = restore.path("exptime").longValue();
        String crc32FromDocument = restore.path("value_crc32c").textValue();
        int currentUserFlags = restore.path("flags").intValue();
        if (doc.field(8).status().success()) {
            byte[] raw = doc.field(8).value();
            stagedContentBinary = Optional.of(raw);
        }
        if (doc.field(9).status().success()) {
            JsonNode docExpiryNode;
            JsonNode aux = MAPPER.readValue(doc.field(9).value(), JsonNode.class);
            if (aux.has("uf")) {
                stagedUserFlags = Optional.of(aux.get("uf").intValue());
            }
            if ((docExpiryNode = aux.get("docexpiry")) != null) {
                long raw = docExpiryNode.longValue();
                stagedExpiry = Optional.of(CoreExpiry.of(Instant.ofEpochSecond(raw)));
            }
        }
        byte[] bodyContent = doc.field(10).status().success() ? doc.field(10).value() : new byte[]{};
        TransactionLinks links = new TransactionLinks(stagedContentJson, stagedContentBinary, atrId, atrBucketName, atrScopeName, atrCollectionName, transactionId, attemptId, casPreTxn, revidPreTxn, exptimePreTxn, op, doc.tombstone(), crc32OfStaging, forwardCompatibility, operationId, stagedUserFlags, stagedExpiry);
        DocumentMetadata md = new DocumentMetadata(casFromDocument, revidFromDocument, exptimeFromDocument);
        return new CoreTransactionGetResult(documentId, bodyContent, currentUserFlags, doc.cas(), collection, links, Optional.of(md), Optional.empty(), Optional.of(crc32FromDocument));
    }

    public CollectionIdentifier collection() {
        return this.collection;
    }

    public int userFlags() {
        return this.userFlags;
    }
}

