/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar;

import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.metrics.NoopMeter;
import com.couchbase.client.core.cnc.metrics.ResponseMetricIdentifier;
import com.couchbase.client.core.cnc.tracing.TracingAttribute;
import com.couchbase.client.core.cnc.tracing.TracingDecorator;
import com.couchbase.client.core.deps.io.grpc.Deadline;
import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.core.error.context.CancellationErrorContext;
import com.couchbase.client.core.error.context.GenericErrorContext;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.retry.ProtostellarRequestBehaviour;
import com.couchbase.client.core.retry.RetryReason;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ProtostellarRequest<TGrpcRequest> {
    private static final Logger log = LoggerFactory.getLogger(ProtostellarRequest.class);
    private final CoreProtostellar core;
    @Nullable
    private final RequestSpan span;
    private final long absoluteTimeout;
    private long encodeDurationNanos;
    private final RetryStrategy retryStrategy;
    private final long createdAt = System.nanoTime();
    protected final ServiceType serviceType;
    private final String requestName;
    private final boolean readonly;
    private final Duration timeout;
    private final Deadline deadline;
    private final Map<String, Object> clientContext;
    private final TGrpcRequest request;
    private long logicallyCompletedAt;
    private long lastDispatchDurationNanos;
    private long totalDispatchDurationNanos;
    private int retryAttempts;
    private Set<RetryReason> retryReasons;
    private CancellationReason cancellationReason;
    private volatile State state = State.INCOMPLETE;
    @Nullable
    private Consumer<Map<String, Object>> contextSupplier;

    public ProtostellarRequest(TGrpcRequest request, CoreProtostellar core, ServiceType serviceType, String requestName, RequestSpan span, Duration timeout, boolean readonly, RetryStrategy retryStrategy, Map<String, Object> clientContext, long encodeDurationNanos, @Nullable Consumer<Map<String, Object>> contextSupplier) {
        this.request = request;
        this.core = core;
        this.serviceType = serviceType;
        this.requestName = requestName;
        this.span = span;
        this.absoluteTimeout = System.nanoTime() + timeout.toNanos();
        this.readonly = readonly;
        this.retryStrategy = retryStrategy;
        this.timeout = timeout;
        this.deadline = CoreProtostellarUtil.convertTimeout(timeout);
        this.clientContext = clientContext;
        this.encodeDurationNanos = encodeDurationNanos;
        this.contextSupplier = contextSupplier;
    }

    public TGrpcRequest request() {
        return this.request;
    }

    public RequestSpan span() {
        return this.span;
    }

    public void raisedResponseToUser(@Nullable Throwable err) {
        if (this.state != State.INCOMPLETE) {
            throw new IllegalStateException("Trying to raise a response multiple times on the same request - internal bug");
        }
        State state = this.state = err == null ? State.SUCCEEDED : State.FAILED;
        if (this.span != null) {
            if (!CbTracing.isInternalSpan(this.span)) {
                TracingDecorator tip = this.core.context().coreResources().tracingDecorator();
                tip.provideAttr(TracingAttribute.RETRIES, this.span, this.retryAttempts());
                if (err != null) {
                    this.span.recordException(err);
                    this.span.status(RequestSpan.StatusCode.ERROR);
                }
            }
            this.span.end();
        }
        if (!(this.core.context().environment().meter() instanceof NoopMeter)) {
            long latency = this.logicalRequestLatency();
            boolean isDefaultLoggingMeter = this.core.context().coreResources().meter().isDefaultLoggingMeter();
            if (latency > 0L) {
                ResponseMetricIdentifier rmi = new ResponseMetricIdentifier(this.serviceType.id(), this.requestName, null, null, null, null, null, isDefaultLoggingMeter);
                try {
                    this.core.responseMetric(rmi).recordValue(latency);
                }
                catch (Exception e) {
                    log.warn("Failed to record request latency ({}). {}", new Object[]{Duration.ofNanos(latency), this.context(), e});
                }
            }
        }
    }

    public Duration timeout() {
        return this.timeout;
    }

    public Deadline deadline() {
        return this.deadline;
    }

    public long absoluteTimeout() {
        return this.absoluteTimeout;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public boolean timeoutElapsed() {
        return this.absoluteTimeout - System.nanoTime() <= 0L;
    }

    public ProtostellarRequestBehaviour cancel(CancellationReason reason) {
        this.cancellationReason = reason;
        String msg = this.getClass().getSimpleName() + ", Reason: " + reason;
        CancellationErrorContext ctx = new CancellationErrorContext(this.context());
        RequestCanceledException exception = new RequestCanceledException(msg, reason, ctx);
        return ProtostellarRequestBehaviour.fail(exception);
    }

    public boolean readonly() {
        return this.readonly;
    }

    public long logicalRequestLatency() {
        if (this.logicallyCompletedAt == 0L || this.logicallyCompletedAt <= this.createdAt) {
            return 0L;
        }
        return this.logicallyCompletedAt - this.createdAt;
    }

    public void incrementRetryAttempts(Duration duration, RetryReason reason) {
        ++this.retryAttempts;
        if (this.retryReasons == null) {
            this.retryReasons = new HashSet<RetryReason>();
        }
        this.retryReasons.add(reason);
    }

    public GenericErrorContext context() {
        HashMap<String, Object> input = new HashMap<String, Object>();
        if (this.contextSupplier != null) {
            this.contextSupplier.accept(input);
        }
        input.put("readonly", this.readonly);
        input.put("requestName", this.requestName);
        input.put("retried", this.retryAttempts);
        input.put("completed", this.completed());
        input.put("timeoutMs", this.timeout.toMillis());
        if (this.cancellationReason != null) {
            input.put("cancelled", true);
            input.put("reason", this.cancellationReason);
        }
        if (this.clientContext != null) {
            input.put("clientContext", this.clientContext);
        }
        if (this.retryReasons != null) {
            input.put("retryReasons", this.retryReasons);
        }
        long logicalLatency = this.logicalRequestLatency();
        if (this.lastDispatchDurationNanos != 0L || logicalLatency != 0L || this.encodeDurationNanos != 0L) {
            HashMap<String, Long> timings = new HashMap<String, Long>();
            if (this.lastDispatchDurationNanos != 0L) {
                timings.put("lastDispatchMicros", TimeUnit.NANOSECONDS.toMicros(this.lastDispatchDurationNanos));
            }
            if (this.totalDispatchDurationNanos != 0L) {
                timings.put("totalDispatchMicros", TimeUnit.NANOSECONDS.toMicros(this.totalDispatchDurationNanos));
            }
            if (logicalLatency != 0L) {
                timings.put("totalMicros", TimeUnit.NANOSECONDS.toMicros(logicalLatency));
            }
            if (this.encodeDurationNanos != 0L) {
                timings.put("encodingMicros", TimeUnit.NANOSECONDS.toMicros(this.encodeDurationNanos));
            }
            input.put("timings", timings);
        }
        return new GenericErrorContext(input, null);
    }

    public int retryAttempts() {
        return this.retryAttempts;
    }

    public void dispatchDuration(long durationNanos) {
        this.lastDispatchDurationNanos = durationNanos;
        this.totalDispatchDurationNanos += durationNanos;
    }

    public boolean completed() {
        return this.state != State.INCOMPLETE;
    }

    public long createdAt() {
        return this.createdAt;
    }

    public ServiceType serviceType() {
        return this.serviceType;
    }

    @Nullable
    public CancellationReason cancellationReason() {
        return this.cancellationReason;
    }

    public boolean failed() {
        return this.state == State.FAILED;
    }

    public boolean succeeded() {
        return this.state == State.SUCCEEDED;
    }

    private static enum State {
        INCOMPLETE,
        SUCCEEDED,
        FAILED;

    }
}

