/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.manager;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.manager.CoreBuildQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreCreatePrimaryQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreCreateQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreDropPrimaryQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreDropQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreGetAllQueryIndexesOptions;
import com.couchbase.client.core.api.manager.CoreQueryIndex;
import com.couchbase.client.core.api.manager.CoreScopeAndCollection;
import com.couchbase.client.core.api.manager.CoreWatchQueryIndexesOptions;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.tracing.RequestTracerAndDecorator;
import com.couchbase.client.core.cnc.tracing.TracingAttribute;
import com.couchbase.client.core.cnc.tracing.TracingDecorator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.IndexExistsException;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.error.IndexesNotReadyException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.manager.CoreCollectionQueryIndexManager;
import com.couchbase.client.core.manager.CoreQueryType;
import com.couchbase.client.core.retry.reactor.Retry;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreQueryIndexManager {
    private final RequestTracerAndDecorator requestTracer;
    private final CoreQueryOps queryOps;

    public CoreQueryIndexManager(CoreQueryOps queryOps, RequestTracerAndDecorator requestTracer) {
        this.requestTracer = Objects.requireNonNull(requestTracer);
        this.queryOps = Objects.requireNonNull(queryOps);
    }

    public static ObjectNode getParamsForGetAllIndexes(String bucket, @Nullable String scope, @Nullable String collection) {
        ObjectNode params = Mapper.createObjectNode();
        params.put("bucketName", bucket);
        params.put("scopeName", scope);
        params.put("collectionName", collection);
        return params;
    }

    @Deprecated
    public static Map<String, String> getNamedParamsForGetAllIndexes(@Nullable String bucket, @Nullable String scope, @Nullable String collection) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("bucketName", bucket);
        params.put("scopeName", scope);
        params.put("collectionName", collection);
        return params;
    }

    public static String getStatementForGetAllIndexes(String bucket, @Nullable String scope, @Nullable String collection) {
        if (collection != null && scope == null) {
            throw new InvalidArgumentException("When collection is non-null, scope must also be non-null.", null, null);
        }
        String bucketCondition = "(bucket_id = $bucketName)";
        String scopeCondition = "(" + bucketCondition + " AND scope_id = $scopeName)";
        String collectionCondition = "(" + scopeCondition + " AND keyspace_id = $collectionName)";
        String whereCondition = collection != null ? collectionCondition : (scope != null ? scopeCondition : bucketCondition);
        if ("_default".equals(collection) || collection == null) {
            String defaultCollectionCondition = "(bucket_id IS MISSING AND keyspace_id = $bucketName)";
            whereCondition = "(" + whereCondition + " OR " + defaultCollectionCondition + ")";
        }
        return "SELECT idx.* FROM system:indexes AS idx WHERE " + whereCondition + " AND `using` = \"gsi\" ORDER BY is_primary DESC, name ASC";
    }

    public CompletableFuture<Void> createIndex(String bucketName, String indexName, Collection<String> fields, CoreCreateQueryIndexOptions options) {
        Validators.notNullOrEmpty(bucketName, "BucketName");
        Validators.notNullOrEmpty(indexName, "IndexName");
        Validators.notNullOrEmpty(fields, "Fields");
        Validators.notNull(options, "Options");
        String keyspace = CoreQueryIndexManager.buildKeyspace(bucketName, options.scopeAndCollection());
        String statement = "CREATE INDEX " + CoreCollectionQueryIndexManager.quote(new String[]{indexName}) + " ON " + keyspace + CoreCollectionQueryIndexManager.formatIndexFields(fields);
        Map<String, Object> with = CoreCollectionQueryIndexManager.createIndexWith(options);
        return ((CompletableFuture)this.exec(CoreQueryType.WRITE, statement, with, options.commonOptions(), "manager_query_create_index", bucketName, null).exceptionally(t -> {
            if (options.ignoreIfExists() && CbThrowables.hasCause(t, IndexExistsException.class)) {
                return null;
            }
            CbThrowables.throwIfUnchecked(t);
            throw new RuntimeException((Throwable)t);
        })).thenApply(result -> null);
    }

    public CompletableFuture<Void> createPrimaryIndex(String bucketName, CoreCreatePrimaryQueryIndexOptions options) {
        Validators.notNullOrEmpty(bucketName, "BucketName");
        Validators.notNull(options, "Options");
        String keyspace = CoreQueryIndexManager.buildKeyspace(bucketName, options.scopeAndCollection());
        String statement = "CREATE PRIMARY INDEX ";
        if (options.indexName() != null) {
            statement = statement + CoreCollectionQueryIndexManager.quote(new String[]{options.indexName()}) + " ";
        }
        statement = statement + "ON " + keyspace;
        Map<String, Object> with = CoreCollectionQueryIndexManager.createIndexWith(options);
        return ((CompletableFuture)this.exec(CoreQueryType.WRITE, statement, with, options.commonOptions(), "manager_query_create_primary_index", bucketName, null).exceptionally(t -> {
            if (options.ignoreIfExists() && CbThrowables.hasCause(t, IndexExistsException.class)) {
                return null;
            }
            CbThrowables.throwIfUnchecked(t);
            throw new RuntimeException((Throwable)t);
        })).thenApply(result -> null);
    }

    public CompletableFuture<List<CoreQueryIndex>> getAllIndexes(String bucketName, CoreGetAllQueryIndexesOptions options) {
        Validators.notNullOrEmpty(bucketName, "BucketName");
        Validators.notNull(options, "Options");
        String statement = CoreQueryIndexManager.getStatementForGetAllIndexes(bucketName, options.scopeName(), options.collectionName());
        ObjectNode params = CoreQueryIndexManager.getParamsForGetAllIndexes(bucketName, options.scopeName(), options.collectionName());
        return this.exec(CoreQueryType.READ_ONLY, statement, options.commonOptions(), "manager_query_get_all_indexes", bucketName, params).thenApply(result -> result.rows().map(CoreQueryIndex::new).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> dropPrimaryIndex(String bucketName, CoreDropPrimaryQueryIndexOptions options) {
        Validators.notNullOrEmpty(bucketName, "BucketName");
        Validators.notNull(options, "Options");
        String keyspace = CoreQueryIndexManager.buildKeyspace(bucketName, options.scopeAndCollection());
        String statement = "DROP PRIMARY INDEX ON " + keyspace;
        return ((CompletableFuture)this.exec(CoreQueryType.WRITE, statement, options.commonOptions(), "manager_query_drop_primary_index", bucketName, null).exceptionally(t -> {
            if (options.ignoreIfNotExists() && CbThrowables.hasCause(t, IndexNotFoundException.class)) {
                return null;
            }
            CbThrowables.throwIfUnchecked(t);
            throw new RuntimeException((Throwable)t);
        })).thenApply(result -> null);
    }

    public CompletableFuture<Void> dropIndex(String bucketName, String indexName, CoreDropQueryIndexOptions options) {
        Validators.notNullOrEmpty(bucketName, "BucketName");
        Validators.notNullOrEmpty(indexName, "IndexName");
        Validators.notNull(options, "Options");
        String statement = options.scopeAndCollection() != null ? "DROP INDEX " + CoreCollectionQueryIndexManager.quote(new String[]{indexName}) + " ON " + CoreQueryIndexManager.buildKeyspace(bucketName, options.scopeAndCollection()) : "DROP INDEX " + CoreCollectionQueryIndexManager.quote(bucketName, indexName);
        return ((CompletableFuture)this.exec(CoreQueryType.WRITE, statement, options.commonOptions(), "manager_query_drop_index", bucketName, null).exceptionally(t -> {
            if (options.ignoreIfNotExists() && CbThrowables.hasCause(t, IndexNotFoundException.class)) {
                return null;
            }
            CbThrowables.throwIfUnchecked(t);
            throw new RuntimeException((Throwable)t);
        })).thenApply(result -> null);
    }

    public CompletableFuture<Void> buildDeferredIndexes(String bucketName, final CoreBuildQueryIndexOptions options) {
        Validators.notNullOrEmpty(bucketName, "BucketName");
        Validators.notNull(options, "Options");
        CoreGetAllQueryIndexesOptions getAllOptions = new CoreGetAllQueryIndexesOptions(){

            @Override
            public String scopeName() {
                return options.scopeAndCollection() != null ? options.scopeAndCollection().scopeName() : "_default";
            }

            @Override
            public String collectionName() {
                return options.scopeAndCollection() != null ? options.scopeAndCollection().collectionName() : "_default";
            }

            @Override
            public CoreCommonOptions commonOptions() {
                return options.commonOptions();
            }
        };
        return Reactor.toMono(() -> this.getAllIndexes(bucketName, getAllOptions)).map(indexes -> indexes.stream().filter(idx -> idx.state().equals("deferred")).map(idx -> CoreCollectionQueryIndexManager.quote(new String[]{idx.name()})).collect(Collectors.toList())).flatMap(indexNames -> {
            if (indexNames.isEmpty()) {
                return Mono.empty();
            }
            String keyspace = options.scopeAndCollection() != null ? CoreQueryIndexManager.buildKeyspace(bucketName, options.scopeAndCollection()) : CoreCollectionQueryIndexManager.quote(new String[]{bucketName});
            String statement = "BUILD INDEX ON " + keyspace + " (" + String.join((CharSequence)",", indexNames) + ")";
            return Reactor.toMono(() -> this.exec(CoreQueryType.WRITE, statement, options.commonOptions(), "manager_query_build_deferred_indexes", bucketName, null).thenApply(result -> null));
        }).then().toFuture();
    }

    public CompletableFuture<Void> watchIndexes(String bucketName, Collection<String> indexNames, Duration timeout, CoreWatchQueryIndexesOptions options) {
        Validators.notNullOrEmpty(bucketName, "BucketName");
        Validators.notNull(indexNames, "IndexNames");
        Validators.notNull(timeout, "Timeout");
        Validators.notNull(options, "Options");
        HashSet<String> indexNameSet = new HashSet<String>(indexNames);
        RequestSpan parent = this.requestTracer.requestTracer.requestSpan("manager_query_watch_indexes", options.commonOptions().parentSpan().orElse(null));
        this.setupSpan(bucketName, parent);
        return Mono.fromFuture(() -> this.failIfIndexesOffline(bucketName, indexNameSet, options.watchPrimary(), parent, options.scopeAndCollection())).retryWhen(Retry.onlyIf(ctx -> CbThrowables.hasCause(ctx.exception(), IndexesNotReadyException.class)).exponentialBackoff(Duration.ofMillis(50L), Duration.ofSeconds(1L)).timeout(timeout).toReactorRetry()).onErrorMap(t -> CoreCollectionQueryIndexManager.toWatchTimeoutException(t, timeout)).toFuture().whenComplete((r, t) -> parent.end());
    }

    private void setupSpan(@Nullable String bucketName, RequestSpan parent) {
        TracingDecorator tip = this.requestTracer.decorator;
        if (bucketName != null) {
            tip.provideLowCardinalityAttr(TracingAttribute.BUCKET_NAME, parent, bucketName);
        }
        tip.provideManagerOrActualService(parent, "query");
    }

    private CompletableFuture<Void> failIfIndexesOffline(String bucketName, Set<String> indexNames, boolean includePrimary, final RequestSpan parentSpan, final CoreScopeAndCollection scopeAndCollection) throws IndexesNotReadyException, IndexNotFoundException {
        Objects.requireNonNull(bucketName);
        Objects.requireNonNull(indexNames);
        CoreGetAllQueryIndexesOptions getAllQueryIndexesOptions = new CoreGetAllQueryIndexesOptions(){

            @Override
            public String scopeName() {
                return scopeAndCollection != null ? scopeAndCollection.scopeName() : "_default";
            }

            @Override
            public String collectionName() {
                return scopeAndCollection != null ? scopeAndCollection.collectionName() : "_default";
            }

            @Override
            public CoreCommonOptions commonOptions() {
                return CoreCommonOptions.of(null, null, parentSpan);
            }
        };
        return this.getAllIndexes(bucketName, getAllQueryIndexesOptions).thenApply(allIndexes -> CoreCollectionQueryIndexManager.failIfIndexesOfflineHelper(indexNames, includePrimary, allIndexes));
    }

    private CompletableFuture<CoreQueryResult> exec(CoreQueryType queryType, CharSequence statement, @Nullable Map<String, Object> with, CoreCommonOptions options, String spanName, String bucketName, ObjectNode parameters) {
        return with == null || with.isEmpty() ? this.exec(queryType, statement, options, spanName, bucketName, parameters) : this.exec(queryType, statement + " WITH " + Mapper.encodeAsString(with), options, spanName, bucketName, parameters);
    }

    private CompletableFuture<CoreQueryResult> exec(CoreQueryType queryType, CharSequence statement, CoreCommonOptions options, String spanName, @Nullable String bucketName, ObjectNode parameters) {
        RequestSpan parent = this.requestTracer.requestTracer.requestSpan(spanName, options.parentSpan().orElse(null));
        CoreCommonOptions common = CoreCommonOptions.ofOptional(options.timeout(), options.retryStrategy(), Optional.of(parent));
        CoreQueryOptions queryOpts = CoreQueryIndexManager.toQueryOptions(common, Objects.requireNonNull(queryType) == CoreQueryType.READ_ONLY, parameters);
        this.setupSpan(bucketName, parent);
        return this.queryOps.queryAsync(statement.toString(), queryOpts, null, null, null).toFuture().whenComplete((r, t) -> parent.end());
    }

    private static CoreQueryOptions toQueryOptions(CoreCommonOptions options, boolean readonly, ObjectNode parameters) {
        return CoreCollectionQueryIndexManager.toQueryOptions(options, readonly, parameters);
    }

    private static String buildKeyspace(String bucket, @Nullable CoreScopeAndCollection scopeAndCollection) {
        if (scopeAndCollection != null) {
            return CoreCollectionQueryIndexManager.quote(bucket, scopeAndCollection.scopeName(), scopeAndCollection.collectionName());
        }
        return CoreCollectionQueryIndexManager.quote(new String[]{bucket});
    }
}

