/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv.sasl;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.env.SaslMechanism;
import com.couchbase.client.core.util.CbStrings;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@Stability.Internal
public class SingleStepSaslAuthParameters {
    private final SaslMechanism mechanism;
    private final String payload;

    private SingleStepSaslAuthParameters(SaslMechanism mechanism, String payload) {
        if (mechanism.roundtrips() != 1) {
            throw new IllegalArgumentException((Object)((Object)mechanism) + " is not allowed here because it does not have exactly one round trip.");
        }
        this.mechanism = Objects.requireNonNull(mechanism);
        this.payload = Objects.requireNonNull(payload);
    }

    public SaslMechanism mechanism() {
        return this.mechanism;
    }

    public String payload() {
        return this.payload;
    }

    public static SingleStepSaslAuthParameters plain(@Nullable String authorizationId, String username, String password) {
        String payload = CbStrings.nullToEmpty(authorizationId) + "\u0000" + username + "\u0000" + password;
        return new SingleStepSaslAuthParameters(SaslMechanism.PLAIN, payload);
    }

    public static SingleStepSaslAuthParameters oauthbearer(@Nullable String authorizationId, String token) {
        String authorizationComponent = authorizationId == null ? "" : "a=" + authorizationId;
        String payload = "n," + authorizationComponent + ",\u0001auth=Bearer " + token + "\u0001\u0001";
        return new SingleStepSaslAuthParameters(SaslMechanism.OAUTHBEARER, payload);
    }

    public String toString() {
        return "SingleStepSaslAuthParameters{mechanism=" + (Object)((Object)this.mechanism) + ", payload=<redacted>" + '}';
    }
}

