/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public enum SaslMechanism {
    PLAIN("PLAIN", 1),
    SCRAM_SHA1("SCRAM-SHA1", 2),
    SCRAM_SHA256("SCRAM-SHA256", 2),
    SCRAM_SHA512("SCRAM-SHA512", 2),
    OAUTHBEARER("OAUTHBEARER", 1);

    private final String mech;
    private final int roundtrips;
    private static final Map<String, SaslMechanism> lookupTable;

    private SaslMechanism(String mech, int roundtrips) {
        this.mech = Objects.requireNonNull(mech);
        this.roundtrips = roundtrips;
    }

    public String mech() {
        return this.mech;
    }

    public int roundtrips() {
        return this.roundtrips;
    }

    public static @Nullable SaslMechanism from(String mech) {
        return lookupTable.get(mech);
    }

    static {
        lookupTable = Collections.unmodifiableMap(Arrays.stream(SaslMechanism.values()).collect(Collectors.toMap(it -> it.mech, it -> it)));
    }
}

