/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.cnc.tracing.TracingAttribute;
import com.couchbase.client.core.cnc.tracing.TracingDecorator;
import com.couchbase.client.core.topology.ClusterIdentifier;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

@Stability.Internal
public class RequestTracerDecorator
implements RequestTracer {
    private final RequestTracer wrapped;
    private final Supplier<ClusterIdentifier> clusterIdentSupplier;
    private final TracingDecorator tip;

    public RequestTracerDecorator(RequestTracer wrapped, TracingDecorator tip, Supplier<ClusterIdentifier> clusterIdentSupplier) {
        this.wrapped = Objects.requireNonNull(wrapped);
        this.clusterIdentSupplier = clusterIdentSupplier;
        this.tip = Objects.requireNonNull(tip);
    }

    @Override
    public RequestSpan requestSpan(String name, RequestSpan parent) {
        RequestSpan span = this.wrapped.requestSpan(name, parent);
        this.tip.provideLowCardinalityAttr(TracingAttribute.SYSTEM, span, "couchbase");
        ClusterIdentifier clusterIdent = this.clusterIdentSupplier.get();
        if (clusterIdent != null) {
            this.tip.provideAttr(TracingAttribute.CLUSTER_NAME, span, clusterIdent.clusterName());
            this.tip.provideAttr(TracingAttribute.CLUSTER_UUID, span, clusterIdent.clusterUuid());
        }
        return span;
    }

    @Override
    public Mono<Void> start() {
        return this.wrapped.start();
    }

    @Override
    public Mono<Void> stop(Duration timeout) {
        return this.wrapped.stop(timeout);
    }

    public String toString() {
        return this.wrapped.getClass().getSimpleName();
    }
}

