/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import java.util.Objects;

@Stability.Internal
public class OwnedOrExternal<T> {
    private final boolean owned;
    private final T resource;

    public static <T> OwnedOrExternal<T> owned(T resource) {
        return new OwnedOrExternal<T>(true, resource);
    }

    public static <T> OwnedOrExternal<T> external(T resource) {
        return new OwnedOrExternal<T>(false, resource);
    }

    private OwnedOrExternal(boolean owned, T resource) {
        this.owned = owned;
        this.resource = Objects.requireNonNull(resource);
    }

    public boolean isOwned() {
        return this.owned;
    }

    public T get() {
        return this.resource;
    }

    public String toString() {
        return (this.owned ? "Owned" : "External") + "{" + this.resource + "}";
    }
}

