/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.endpoint.CircuitBreaker;
import com.couchbase.client.core.error.TimeoutException;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;

public class CircuitBreakerConfig {
    public static final boolean DEFAULT_ENABLED = true;
    public static final int DEFAULT_VOLUME_THRESHOLD = 20;
    public static final int DEFAULT_ERROR_THRESHOLD_PERCENTAGE = 50;
    public static final Duration DEFAULT_SLEEP_WINDOW = Duration.ofSeconds(5L);
    public static final Duration DEFAULT_ROLLING_WINDOW = Duration.ofMinutes(1L);
    public static final CircuitBreaker.CompletionCallback DEFAULT_COMPLETION_CALLBACK = (response, throwable) -> !(throwable instanceof TimeoutException);
    private final boolean enabled;
    private final int volumeThreshold;
    private final int errorThresholdPercentage;
    private final Duration sleepWindow;
    private final Duration rollingWindow;
    private final CircuitBreaker.CompletionCallback completionCallback;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder enabled(boolean enabled) {
        return CircuitBreakerConfig.builder().enabled(enabled);
    }

    public static Builder volumeThreshold(int volumeThreshold) {
        return CircuitBreakerConfig.builder().volumeThreshold(volumeThreshold);
    }

    public static Builder errorThresholdPercentage(int errorThresholdPercentage) {
        return CircuitBreakerConfig.builder().errorThresholdPercentage(errorThresholdPercentage);
    }

    public static Builder sleepWindow(Duration sleepWindow) {
        return CircuitBreakerConfig.builder().sleepWindow(sleepWindow);
    }

    public static Builder rollingWindow(Duration rollingWindow) {
        return CircuitBreakerConfig.builder().rollingWindow(rollingWindow);
    }

    public static Builder completionCallback(CircuitBreaker.CompletionCallback completionCallback) {
        return CircuitBreakerConfig.builder().completionCallback(completionCallback);
    }

    private CircuitBreakerConfig(Builder builder) {
        this.enabled = builder.enabled;
        this.volumeThreshold = builder.volumeThreshold;
        this.errorThresholdPercentage = builder.errorThresholdPercentage;
        this.sleepWindow = builder.sleepWindow;
        this.rollingWindow = builder.rollingWindow;
        this.completionCallback = builder.completionCallback;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public int volumeThreshold() {
        return this.volumeThreshold;
    }

    public int errorThresholdPercentage() {
        return this.errorThresholdPercentage;
    }

    public Duration sleepWindow() {
        return this.sleepWindow;
    }

    public Duration rollingWindow() {
        return this.rollingWindow;
    }

    public CircuitBreaker.CompletionCallback completionCallback() {
        return this.completionCallback;
    }

    @Stability.Volatile
    public Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("enabled", this.enabled);
        export.put("volumeThreshold", this.volumeThreshold);
        export.put("errorThresholdPercentage", this.errorThresholdPercentage);
        export.put("sleepWindowMs", this.sleepWindow.toMillis());
        export.put("rollingWindowMs", this.rollingWindow.toMillis());
        export.put("completionCallback", this.completionCallback.getClass().getSimpleName());
        return export;
    }

    public static class Builder {
        private boolean enabled = true;
        private int volumeThreshold = 20;
        private int errorThresholdPercentage = 50;
        private Duration sleepWindow = DEFAULT_SLEEP_WINDOW;
        private Duration rollingWindow = DEFAULT_ROLLING_WINDOW;
        private CircuitBreaker.CompletionCallback completionCallback = DEFAULT_COMPLETION_CALLBACK;

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder volumeThreshold(int volumeThreshold) {
            this.volumeThreshold = volumeThreshold;
            return this;
        }

        public Builder errorThresholdPercentage(int errorThresholdPercentage) {
            this.errorThresholdPercentage = errorThresholdPercentage;
            return this;
        }

        public Builder sleepWindow(Duration sleepWindow) {
            Validators.notNull(sleepWindow, "SleepWindow");
            this.sleepWindow = sleepWindow;
            return this;
        }

        public Builder rollingWindow(Duration rollingWindow) {
            Validators.notNull(rollingWindow, "RollingWindow");
            this.rollingWindow = rollingWindow;
            return this;
        }

        public Builder completionCallback(CircuitBreaker.CompletionCallback completionCallback) {
            Validators.notNull(completionCallback, "CompletionCallback");
            this.completionCallback = completionCallback;
            return this;
        }

        public CircuitBreakerConfig build() {
            return new CircuitBreakerConfig(this);
        }
    }
}

