/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.tracing;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.tracing.TracingAttribute;
import com.couchbase.client.core.cnc.tracing.TracingDecoratorImpl;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class TracingDecoratorImplV1
implements TracingDecoratorImpl {
    private static final String NET_TRANSPORT_TCP = "tcp";

    @Override
    @Nullable
    public String attributeName(TracingAttribute attribute) {
        switch (attribute) {
            case SERVICE: {
                return "couchbase.service";
            }
            case BUCKET_NAME: {
                return "db.namespace";
            }
            case SCOPE_NAME: {
                return "couchbase.scope.name";
            }
            case COLLECTION_NAME: {
                return "couchbase.collection.name";
            }
            case DOCUMENT_ID: {
                return "couchbase.document_id";
            }
            case DURABILITY: {
                return "couchbase.durability";
            }
            case OUTCOME: {
                return "error.type";
            }
            case SERVER_DURATION: {
                return "couchbase.server_duration";
            }
            case OPERATION_ID: {
                return "couchbase.operation_id";
            }
            case LOCAL_ID: {
                return "couchbase.local_id";
            }
            case LOCAL_HOSTNAME: {
                return "net.host.name";
            }
            case LOCAL_PORT: {
                return "net.host.port";
            }
            case REMOTE_HOSTNAME: {
                return "server.address";
            }
            case REMOTE_PORT: {
                return "server.port";
            }
            case PEER_HOSTNAME: {
                return "network.peer.address";
            }
            case PEER_PORT: {
                return "network.peer.port";
            }
            case RETRIES: {
                return "couchbase.retries";
            }
            case STATEMENT: {
                return "db.query.text";
            }
            case TRANSACTION_SINGLE_QUERY: {
                return "couchbase.transaction.single_query";
            }
            case OPERATION: {
                return "db.operation.name";
            }
            case TRANSACTION_ID: {
                return "couchbase.transaction.id";
            }
            case TRANSACTION_ATTEMPT_ID: {
                return "couchbase.transaction.attempt_id";
            }
            case TRANSACTION_STATE: {
                return "couchbase.transaction.state";
            }
            case TRANSACTION_AGE: {
                return "couchbase.transaction.age_ms";
            }
            case TRANSACTION_CLEANUP_CLIENT_ID: {
                return "couchbase.transactions.cleanup.client_id";
            }
            case TRANSACTION_CLEANUP_WINDOW: {
                return "couchbase.transactions.cleanup.window_ms";
            }
            case TRANSACTION_CLEANUP_NUM_ATRS: {
                return "couchbase.transactions.cleanup.client_atrs";
            }
            case TRANSACTION_CLEANUP_NUM_ACTIVE: {
                return "couchbase.transactions.cleanup.clients_active";
            }
            case TRANSACTION_CLEANUP_NUM_EXPIRED: {
                return "couchbase.transactions.cleanup.clients_expired";
            }
            case TRANSACTION_ATR_ENTRIES_COUNT: {
                return "couchbase.transactions.atr.entries_count";
            }
            case TRANSACTION_ATR_ENTRIES_EXPIRED: {
                return "couchbase.transactions.atr.entries_expired";
            }
            case SYSTEM: {
                return "db.system.name";
            }
            case CLUSTER_NAME: {
                return "couchbase.cluster.name";
            }
            case CLUSTER_UUID: {
                return "couchbase.cluster.uuid";
            }
            case NET_TRANSPORT: {
                return "network.transport";
            }
        }
        return null;
    }

    @Override
    public void provideCommonDispatchSpanAttributes(RequestSpan span, @Nullable String localId, @Nullable String localHost, int localPort, @Nullable String remoteCanonicalHost, int remoteCanonicalPort, @Nullable String remoteActualHost, int remoteActualPort, @Nullable String operationId) {
        span.lowCardinalityAttribute(this.requireAttributeName(TracingAttribute.NET_TRANSPORT), NET_TRANSPORT_TCP);
        if (localId != null) {
            span.attribute(this.requireAttributeName(TracingAttribute.LOCAL_ID), localId);
        }
        if (remoteCanonicalHost != null) {
            span.attribute(this.requireAttributeName(TracingAttribute.REMOTE_HOSTNAME), remoteCanonicalHost);
        }
        if (remoteCanonicalPort != 0) {
            span.attribute(this.requireAttributeName(TracingAttribute.REMOTE_PORT), remoteCanonicalPort);
        }
        if (remoteActualHost != null) {
            span.attribute(this.requireAttributeName(TracingAttribute.PEER_HOSTNAME), remoteActualHost);
            span.attribute(this.requireAttributeName(TracingAttribute.PEER_PORT), remoteActualPort);
        }
        if (operationId != null) {
            span.attribute(this.requireAttributeName(TracingAttribute.OPERATION_ID), operationId);
        }
    }

    @Override
    public String managerOrActualService(String actualService) {
        return actualService;
    }

    @Override
    public String meterOperations() {
        return "db.client.operation.duration";
    }
}

