/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.search.v1.PrefixQuery;
import com.couchbase.client.protostellar.search.v1.Query;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CorePrefixQuery
extends CoreSearchQuery {
    private final String prefix;
    @Nullable
    private final String field;

    public CorePrefixQuery(String prefix, @Nullable String field, @Nullable Double boost) {
        super(boost);
        this.prefix = Validators.notNull(prefix, "Prefix");
        this.field = field;
    }

    @Override
    protected void injectParams(ObjectNode input) {
        input.put("prefix", this.prefix);
        if (this.field != null) {
            input.put("field", this.field);
        }
    }

    @Override
    public Query asProtostellar() {
        PrefixQuery.Builder builder = PrefixQuery.newBuilder().setPrefix(this.prefix);
        if (this.field != null) {
            builder.setField(this.field);
        }
        if (this.boost != null) {
            builder.setBoost(this.boost.floatValue());
        }
        return Query.newBuilder().setPrefixQuery(builder).build();
    }
}

