/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.kv;

import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreKvResponseMetadata;
import com.couchbase.client.core.api.kv.CoreMutationResult;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreSubdocMutateResult
extends CoreMutationResult {
    private final List<SubDocumentField> fields;

    public CoreSubdocMutateResult(CoreKeyspace keyspace, String key, @Nullable CoreKvResponseMetadata meta, long cas, Optional<MutationToken> mutationToken, List<SubDocumentField> fields) {
        super(meta, keyspace, key, cas, mutationToken);
        this.fields = Objects.requireNonNull(fields);
    }

    public SubDocumentField field(int index) {
        try {
            SubDocumentField value = this.fields.get(index);
            if (value == null) {
                throw new NoSuchElementException("No result exists at index " + index);
            }
            value.error().ifPresent(err -> {
                throw err;
            });
            return value;
        }
        catch (IndexOutOfBoundsException e) {
            throw InvalidArgumentException.fromMessage("Index " + index + " is invalid", e);
        }
    }
}

