/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.CoreLimiter;
import com.couchbase.client.core.CoreResources;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.api.kv.CoreKvBinaryOps;
import com.couchbase.client.core.api.kv.CoreKvOps;
import com.couchbase.client.core.api.manager.CoreBucketAndScope;
import com.couchbase.client.core.api.manager.search.CoreSearchIndexManager;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.search.CoreSearchOps;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.ValueRecorder;
import com.couchbase.client.core.cnc.events.core.ShutdownCompletedEvent;
import com.couchbase.client.core.cnc.events.core.ShutdownInitiatedEvent;
import com.couchbase.client.core.cnc.metrics.AbstractMeter;
import com.couchbase.client.core.cnc.metrics.ResponseMetricIdentifier;
import com.couchbase.client.core.cnc.metrics.ValueRecorderName;
import com.couchbase.client.core.cnc.tracing.TracingDecorator;
import com.couchbase.client.core.diagnostics.ClusterState;
import com.couchbase.client.core.endpoint.ProtostellarEndpoint;
import com.couchbase.client.core.endpoint.ProtostellarPool;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.DelegatingAuthenticator;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.manager.CoreBucketManagerOps;
import com.couchbase.client.core.manager.CoreCollectionManager;
import com.couchbase.client.core.protostellar.ProtostellarContext;
import com.couchbase.client.core.protostellar.kv.ProtostellarCoreKvBinaryOps;
import com.couchbase.client.core.protostellar.kv.ProtostellarCoreKvOps;
import com.couchbase.client.core.protostellar.manager.ProtostellarCoreBucketManager;
import com.couchbase.client.core.protostellar.manager.ProtostellarCoreCollectionManagerOps;
import com.couchbase.client.core.protostellar.manager.ProtostellarCoreSearchIndexManager;
import com.couchbase.client.core.protostellar.query.ProtostellarCoreQueryOps;
import com.couchbase.client.core.protostellar.search.ProtostellarCoreSearchOps;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.core.util.Deadline;
import com.couchbase.client.core.util.HostAndPort;
import com.couchbase.client.core.util.NanoTimestamp;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreProtostellar
implements CoreCouchbaseOps {
    public static final int DEFAULT_PROTOSTELLAR_TLS_PORT = 18098;
    private final ProtostellarPool pool;
    private final ProtostellarContext ctx;
    private final DelegatingAuthenticator authenticator;
    private final Map<ResponseMetricIdentifier, ValueRecorder> responseMetrics = new ConcurrentHashMap<ResponseMetricIdentifier, ValueRecorder>();

    public CoreProtostellar(CoreEnvironment env, Authenticator initialAuthenticator, ConnectionString connectionString) {
        this.authenticator = DelegatingAuthenticator.create(env.securityConfig().tlsEnabled(), initialAuthenticator);
        TracingDecorator tip = new TracingDecorator(env.observabilitySemanticConventions());
        AbstractMeter abstractMeter = new AbstractMeter(env.meter(), env.observabilitySemanticConventions());
        CoreResources coreResources = new CoreResources(env.requestTracer(), tip, abstractMeter);
        this.ctx = new ProtostellarContext(env, this.authenticator, coreResources);
        Validators.notNull(connectionString, "connectionString");
        CoreCouchbaseOps.checkConnectionStringScheme(connectionString, ConnectionString.Scheme.COUCHBASE2);
        if (connectionString.hosts().size() != 1) {
            throw InvalidArgumentException.fromMessage("Connection string with scheme '" + ConnectionString.Scheme.COUCHBASE2.name().toLowerCase(Locale.ROOT) + "' must have exactly one host, but got: " + connectionString.original());
        }
        ConnectionString.UnresolvedSocket first = connectionString.hosts().get(0);
        first.portType().ifPresent(type -> {
            throw InvalidArgumentException.fromMessage("Invalid port type for scheme " + (Object)((Object)connectionString.scheme()) + ": " + (Object)type + " ; " + connectionString.original());
        });
        int port = first.port() == 0 ? 18098 : first.port();
        HostAndPort remote = new HostAndPort(first.host(), port);
        CoreLimiter.incrementAndVerifyNumInstances(env.eventBus());
        this.pool = new ProtostellarPool(this.ctx, remote);
        this.logCoreCreatedEvent(connectionString);
    }

    private void logCoreCreatedEvent(ConnectionString connectionString) {
        LoggerFactory.getLogger((String)Event.Category.CORE.path()).info("[CoreCreatedEvent] {} {}", (Object)Mapper.encodeAsString(CbCollections.mapOf("coreId", this.ctx.hexId(), "connectionString", RedactableArgument.redactSystem(connectionString.original()))), (Object)this.environment().exportAsString(Context.ExportFormat.JSON));
    }

    public ProtostellarContext context() {
        return this.ctx;
    }

    @Override
    public Mono<Void> shutdown(Duration timeout) {
        return Mono.fromRunnable(() -> {
            NanoTimestamp start = NanoTimestamp.now();
            try {
                this.environment().eventBus().publish(new ShutdownInitiatedEvent(this.ctx));
                this.pool.shutdown(timeout);
            }
            finally {
                CoreLimiter.decrement();
                this.environment().eventBus().publish(new ShutdownCompletedEvent(start.elapsed(), this.ctx));
            }
        });
    }

    public ProtostellarEndpoint endpoint() {
        return this.pool.endpoint();
    }

    public ProtostellarPool pool() {
        return this.pool;
    }

    @Stability.Internal
    public ValueRecorder responseMetric(ResponseMetricIdentifier rmi) {
        return this.responseMetrics.computeIfAbsent(rmi, key -> this.coreResources().meter().valueRecorder(ValueRecorderName.OPERATIONS, (ResponseMetricIdentifier)key));
    }

    @Override
    public CoreKvOps kvOps(CoreKeyspace keyspace) {
        return new ProtostellarCoreKvOps(this, keyspace);
    }

    @Override
    public CoreQueryOps queryOps() {
        return new ProtostellarCoreQueryOps(this);
    }

    @Override
    public CoreSearchOps searchOps(@Nullable CoreBucketAndScope scope) {
        return new ProtostellarCoreSearchOps(this, scope);
    }

    @Override
    public CoreKvBinaryOps kvBinaryOps(CoreKeyspace keyspace) {
        return new ProtostellarCoreKvBinaryOps(this, keyspace);
    }

    @Override
    public CoreBucketManagerOps bucketManager() {
        return new ProtostellarCoreBucketManager(this);
    }

    @Override
    public CoreCollectionManager collectionManager(String bucketName) {
        return new ProtostellarCoreCollectionManagerOps(this, bucketName);
    }

    @Override
    public CoreSearchIndexManager clusterSearchIndexManager() {
        return new ProtostellarCoreSearchIndexManager(this, null);
    }

    @Override
    public CoreSearchIndexManager scopeSearchIndexManager(CoreBucketAndScope scope) {
        return new ProtostellarCoreSearchIndexManager(this, scope);
    }

    @Override
    public CoreEnvironment environment() {
        return this.context().environment();
    }

    @Override
    public CoreResources coreResources() {
        return this.context().coreResources();
    }

    @Override
    public Authenticator authenticator() {
        return this.authenticator;
    }

    @Override
    public void authenticator(Authenticator newAuthenticator) {
        Core.requireSameClass(this.authenticator.wrapped(), newAuthenticator);
        this.authenticator.setDelegate(newAuthenticator);
    }

    @Override
    public CompletableFuture<Void> waitUntilReady(Set<ServiceType> serviceTypes, Duration timeout, ClusterState desiredState, @Nullable String bucketName) {
        Deadline deadline = Deadline.of(timeout);
        ArrayList cfs = new ArrayList();
        this.pool().endpoints().forEach(endpoint -> cfs.add(endpoint.waitUntilReady(deadline, desiredState != ClusterState.OFFLINE)));
        if (desiredState == ClusterState.DEGRADED) {
            return CompletableFuture.anyOf(cfs.toArray(new CompletableFuture[0])).thenRun(() -> {});
        }
        return CompletableFuture.allOf(cfs.toArray(new CompletableFuture[0]));
    }
}

