/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.apptelemetry.reporter;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

class BackoffCalculator {
    private final long maxDelayMillis;
    private final List<Long> delayMillisLookupTable;

    BackoffCalculator(Duration initialDelay, Duration maxDelay) {
        long initialDelayMillis = Math.max(1L, initialDelay.toMillis());
        this.maxDelayMillis = Math.max(1L, maxDelay.toMillis());
        if (this.maxDelayMillis < initialDelayMillis) {
            throw new IllegalArgumentException("maxDelay must be <= initialDelay");
        }
        ArrayList<Long> mutableDelays = new ArrayList<Long>();
        long d = initialDelayMillis;
        try {
            do {
                mutableDelays.add(d);
            } while ((d = Math.multiplyExact(d, 2L)) < this.maxDelayMillis);
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        this.delayMillisLookupTable = Collections.unmodifiableList(mutableDelays);
    }

    Duration delayForAttempt(long attempt) {
        long millis = attempt < (long)this.delayMillisLookupTable.size() ? this.delayMillisLookupTable.get((int)attempt) : this.maxDelayMillis;
        long jitteredMillis = (long)((double)millis * ThreadLocalRandom.current().nextDouble());
        return Duration.ofMillis(jitteredMillis);
    }
}

