/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.search.v1.Query;
import com.couchbase.client.protostellar.search.v1.RegexpQuery;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreRegexpQuery
extends CoreSearchQuery {
    private final String regexp;
    @Nullable
    private final String field;

    public CoreRegexpQuery(String regexp, @Nullable String field, @Nullable Double boost) {
        super(boost);
        this.regexp = Validators.notNull(regexp, "Regexp");
        this.field = field;
    }

    @Override
    protected void injectParams(ObjectNode input) {
        input.put("regexp", this.regexp);
        if (this.field != null) {
            input.put("field", this.field);
        }
    }

    @Override
    public Query asProtostellar() {
        RegexpQuery.Builder builder = RegexpQuery.newBuilder().setRegexp(this.regexp);
        if (this.boost != null) {
            builder.setBoost(this.boost.floatValue());
        }
        return Query.newBuilder().setRegexpQuery(builder).build();
    }
}

