/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.analytics;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderValues;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.BaseRequest;
import com.couchbase.client.core.msg.HttpRequest;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkHeader;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkRow;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkTrailer;
import com.couchbase.client.core.msg.analytics.AnalyticsResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AnalyticsRequest
extends BaseRequest<AnalyticsResponse>
implements HttpRequest<AnalyticsChunkHeader, AnalyticsChunkRow, AnalyticsChunkTrailer, AnalyticsResponse> {
    public static final int NO_PRIORITY = 0;
    private static final String uri = "/analytics/service";
    private static final HttpMethod httpMethod = HttpMethod.POST;
    private final byte[] query;
    private final int priority;
    private final boolean idempotent;
    private final String contextId;
    private final String statement;
    private final String bucket;
    private final String scope;
    private final Authenticator authenticator;
    private final boolean translateExceptions;

    public AnalyticsRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, Authenticator authenticator, byte[] query, int priority, boolean idempotent, String contextId, String statement, RequestSpan span, String bucket, String scope) {
        this(timeout, ctx, retryStrategy, authenticator, query, priority, idempotent, contextId, statement, span, bucket, scope, true);
    }

    public AnalyticsRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, Authenticator authenticator, byte[] query, int priority, boolean idempotent, String contextId, String statement, RequestSpan span, String bucket, String scope, boolean translateExceptions) {
        super(timeout, ctx, retryStrategy, span);
        this.query = query;
        this.authenticator = authenticator;
        this.priority = priority;
        this.idempotent = idempotent;
        this.contextId = contextId;
        this.statement = statement;
        this.bucket = bucket;
        this.scope = scope;
        this.translateExceptions = translateExceptions;
        if (span != null && !CbTracing.isInternalSpan(span)) {
            span.lowCardinalityAttribute("db.couchbase.service", "analytics");
            span.attribute("db.statement", statement);
            if (bucket != null) {
                span.attribute("db.name", bucket);
            }
            if (scope != null) {
                span.attribute("db.couchbase.scope", scope);
            }
        }
    }

    public static String queryContext(String bucket, String scope) {
        return "default:`" + bucket + "`.`" + scope + "`";
    }

    @Override
    public FullHttpRequest encode() {
        ByteBuf content = this.query == null || this.query.length == 0 ? Unpooled.EMPTY_BUFFER : Unpooled.wrappedBuffer(this.query);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, uri, content);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
        request.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.context().environment().userAgent().formattedLong());
        if (this.priority != 0) {
            request.headers().set("Analytics-Priority", (Object)this.priority);
        }
        this.authenticator.authHttpRequest(this.serviceType(), request);
        return request;
    }

    @Override
    public AnalyticsResponse decode(ResponseStatus status, AnalyticsChunkHeader header, Flux<AnalyticsChunkRow> rows, Mono<AnalyticsChunkTrailer> trailer) {
        return new AnalyticsResponse(status, header, rows, trailer);
    }

    @Override
    public ServiceType serviceType() {
        return ServiceType.ANALYTICS;
    }

    @Override
    public boolean idempotent() {
        return this.idempotent;
    }

    @Override
    public String operationId() {
        return this.contextId;
    }

    public String statement() {
        return this.statement;
    }

    public boolean translateExceptions() {
        return this.translateExceptions;
    }

    @Override
    public Map<String, Object> serviceContext() {
        TreeMap<String, Object> ctx = new TreeMap<String, Object>();
        ctx.put("type", this.serviceType().ident());
        ctx.put("uri", RedactableArgument.redactMeta(uri));
        ctx.put("httpMethod", httpMethod.toString());
        ctx.put("operationId", RedactableArgument.redactMeta(this.operationId()));
        ctx.put("statement", RedactableArgument.redactUser(this.statement()));
        ctx.put("priority", this.priority);
        if (this.bucket != null) {
            ctx.put("bucket", RedactableArgument.redactMeta(this.bucket));
        }
        if (this.scope != null) {
            ctx.put("scope", RedactableArgument.redactMeta(this.scope));
        }
        return ctx;
    }

    @Override
    public String bucket() {
        return this.bucket;
    }

    public String scope() {
        return this.scope;
    }

    @Override
    public String name() {
        return "analytics";
    }
}

