/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.deps.io.netty.util.internal.ObjectUtil;
import java.util.Objects;

public class ProposedBucketConfigContext {
    private final String bucketName;
    private final String config;
    private final String origin;
    private final boolean forcesOverride;

    public ProposedBucketConfigContext(String bucketName, String config, String origin) {
        this(bucketName, config, origin, false);
    }

    public ProposedBucketConfigContext(String bucketName, String config, String origin, boolean forcesOverride) {
        ObjectUtil.checkNotNull(bucketName, "bucket name cannot be null!");
        ObjectUtil.checkNotNull(config, "the raw config cannot be null!");
        this.bucketName = bucketName;
        this.config = config.replace("$HOST", origin);
        this.origin = origin;
        this.forcesOverride = forcesOverride;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String config() {
        return this.config;
    }

    public String origin() {
        return this.origin;
    }

    public boolean forcesOverride() {
        return this.forcesOverride;
    }

    public ProposedBucketConfigContext forceOverride() {
        return new ProposedBucketConfigContext(this.bucketName, this.config, this.origin, true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProposedBucketConfigContext that = (ProposedBucketConfigContext)o;
        return this.forcesOverride == that.forcesOverride && Objects.equals(this.bucketName, that.bucketName) && Objects.equals(this.config, that.config) && Objects.equals(this.origin, that.origin);
    }

    public int hashCode() {
        return Objects.hash(this.bucketName, this.config, this.origin, this.forcesOverride);
    }

    public String toString() {
        return "ProposedBucketConfigContext{bucketName='" + this.bucketName + '\'' + ", config='" + this.config + '\'' + ", origin='" + this.origin + '\'' + ", forcesOverride=" + this.forcesOverride + '}';
    }
}

