/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.AbstractBucketConfig;
import com.couchbase.client.core.config.BucketCapabilities;
import com.couchbase.client.core.config.BucketNodeLocator;
import com.couchbase.client.core.config.BucketType;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JacksonInject;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.topology.KetamaRing;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MemcachedBucketConfig
extends AbstractBucketConfig {
    private final KetamaRing<NodeInfo> ketamaRing;

    @JsonCreator
    public MemcachedBucketConfig(@JacksonInject(value="env") CoreEnvironment env, @JsonProperty(value="rev") long rev, @JsonProperty(value="revEpoch") long revEpoch, @JsonProperty(value="uuid") String uuid, @JsonProperty(value="name") String name, @JsonProperty(value="uri") String uri, @JsonProperty(value="streamingUri") String streamingUri, @JsonProperty(value="nodes") List<NodeInfo> nodeInfos, @JsonProperty(value="nodesExt") List<PortInfo> portInfos, @JsonProperty(value="bucketCapabilities") List<BucketCapabilities> bucketCapabilities, @JsonProperty(value="clusterCapabilities") Map<String, Set<ClusterCapabilities>> clusterCapabilities, @JacksonInject(value="origin") String origin) {
        super(uuid, name, BucketNodeLocator.KETAMA, uri, streamingUri, nodeInfos, portInfos, bucketCapabilities, origin, clusterCapabilities, rev, revEpoch);
        this.ketamaRing = KetamaRing.create(this.nodes(), env.ioConfig().memcachedHashingStrategy());
    }

    @Override
    public boolean tainted() {
        return false;
    }

    @Override
    public BucketType type() {
        return BucketType.MEMCACHED;
    }

    @Deprecated
    public SortedMap<Long, NodeInfo> ketamaNodes() {
        return this.ketamaRing.toMap();
    }

    KetamaRing<NodeInfo> ketamaRing() {
        return this.ketamaRing;
    }

    @Deprecated
    public NodeIdentifier nodeForId(byte[] id) {
        return this.nodeForKey(id).identifier();
    }

    public NodeInfo nodeForKey(byte[] id) {
        return this.ketamaRing.get(id);
    }

    @Override
    public boolean hasFastForwardMap() {
        return false;
    }

    public String toString() {
        return "MemcachedBucketConfig{name='" + RedactableArgument.redactMeta(this.name()) + '\'' + ", version=" + this.version() + ", nodes=" + RedactableArgument.redactSystem(this.nodes()) + '}';
    }
}

