/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc;

import com.couchbase.client.core.cnc.LoggerFormatter;
import com.couchbase.client.core.error.CouchbaseException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Formatter;
import java.util.Locale;
import java.util.logging.Level;
import reactor.util.annotation.Nullable;

public class DefaultLoggerFormatter
implements LoggerFormatter {
    private static final String CHARSET_NAME = StandardCharsets.UTF_8.displayName();
    public static final DefaultLoggerFormatter INSTANCE = new DefaultLoggerFormatter();

    @Override
    public String format(Level logLevel, String message, @Nullable Throwable throwable) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        Throwable throwable2 = null;
        try (Formatter formatter = new Formatter(ps, Locale.ROOT);){
            String currentThread = Thread.currentThread().getName();
            String convertedLevel = this.logLevel(logLevel);
            String timestamp = this.timestamp();
            if (timestamp != null && !timestamp.isEmpty()) {
                timestamp = timestamp + " ";
            }
            if (throwable == null) {
                formatter.format("%s[%s] (%s) %s%n", timestamp, convertedLevel, currentThread, message);
            } else {
                formatter.format("%s[%s] (%s) %s - %s%n", timestamp, convertedLevel, currentThread, message, throwable);
                throwable.printStackTrace(ps);
            }
            try {
                String string = os.toString(CHARSET_NAME);
                return string;
            }
            catch (UnsupportedEncodingException e) {
                try {
                    throw new CouchbaseException("Unsupported charset while formatting log: " + CHARSET_NAME, e);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
            }
        }
    }

    protected String timestamp() {
        return "";
    }

    protected String logLevel(Level level) {
        switch (level.getName()) {
            case "SEVERE": {
                return "ERROR";
            }
            case "WARNING": {
                return " WARN";
            }
            case "INFO": {
                return " INFO";
            }
            case "CONFIG": 
            case "FINE": 
            case "FINER": {
                return "DEBUG";
            }
            case "FINEST": {
                return "TRACE";
            }
        }
        throw new IllegalStateException("Unsupported Log Level: " + level);
    }
}

