/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreConjunctionQuery;
import com.couchbase.client.core.api.search.queries.CoreDisjunctionQuery;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.protostellar.search.v1.BooleanQuery;
import com.couchbase.client.protostellar.search.v1.Query;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreBooleanQuery
extends CoreSearchQuery {
    @Nullable
    private final CoreConjunctionQuery must;
    @Nullable
    private final CoreDisjunctionQuery mustNot;
    @Nullable
    private final CoreDisjunctionQuery should;

    public CoreBooleanQuery(@Nullable CoreConjunctionQuery must, @Nullable CoreDisjunctionQuery mustNot, @Nullable CoreDisjunctionQuery should, @Nullable Double boost) {
        super(boost);
        boolean shouldIsEmpty;
        boolean mustIsEmpty = must == null || must.childQueries().isEmpty();
        boolean mustNotIsEmpty = mustNot == null || mustNot.childQueries().isEmpty();
        boolean bl = shouldIsEmpty = should == null || should.childQueries().isEmpty();
        if (mustIsEmpty && mustNotIsEmpty && shouldIsEmpty) {
            throw InvalidArgumentException.fromMessage("Boolean query needs at least one of must, mustNot and should");
        }
        this.must = must;
        this.mustNot = mustNot;
        this.should = should;
    }

    @Override
    protected void injectParams(ObjectNode input) {
        boolean shouldIsEmpty;
        boolean mustIsEmpty = this.must == null || this.must.childQueries().isEmpty();
        boolean mustNotIsEmpty = this.mustNot == null || this.mustNot.childQueries().isEmpty();
        boolean bl = shouldIsEmpty = this.should == null || this.should.childQueries().isEmpty();
        if (!mustIsEmpty) {
            ObjectNode jsonMust = Mapper.createObjectNode();
            this.must.injectParamsAndBoost(jsonMust);
            input.set("must", jsonMust);
        }
        if (!mustNotIsEmpty) {
            ObjectNode jsonMustNot = Mapper.createObjectNode();
            this.mustNot.injectParamsAndBoost(jsonMustNot);
            input.set("must_not", jsonMustNot);
        }
        if (!shouldIsEmpty) {
            ObjectNode jsonShould = Mapper.createObjectNode();
            this.should.injectParamsAndBoost(jsonShould);
            input.set("should", jsonShould);
        }
    }

    @Override
    public Query asProtostellar() {
        BooleanQuery.Builder query = BooleanQuery.newBuilder();
        if (this.must != null) {
            query.setMust(this.must.asConjunctionProtostellar());
        }
        if (this.mustNot != null) {
            query.setMustNot(this.mustNot.asDisjunctionProtostellar());
        }
        if (this.should != null) {
            query.setShould(this.should.asDisjunctionProtostellar());
        }
        if (this.boost != null) {
            query.setBoost(this.boost.floatValue());
        }
        return Query.newBuilder().setBooleanQuery(query).build();
    }
}

