/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar;

import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.google.protobuf.Any;
import com.couchbase.client.core.deps.com.google.protobuf.ByteString;
import com.couchbase.client.core.deps.com.google.protobuf.GeneratedMessageV3;
import com.couchbase.client.core.deps.com.google.protobuf.InvalidProtocolBufferException;
import com.couchbase.client.core.deps.com.google.rpc.DebugInfo;
import com.couchbase.client.core.deps.com.google.rpc.ErrorInfo;
import com.couchbase.client.core.deps.com.google.rpc.PreconditionFailure;
import com.couchbase.client.core.deps.com.google.rpc.RequestInfo;
import com.couchbase.client.core.deps.com.google.rpc.ResourceInfo;
import com.couchbase.client.core.deps.com.google.rpc.Status;
import com.couchbase.client.core.deps.io.grpc.Status;
import com.couchbase.client.core.deps.io.grpc.StatusRuntimeException;
import com.couchbase.client.core.deps.io.grpc.protobuf.StatusProto;
import com.couchbase.client.core.error.AmbiguousTimeoutException;
import com.couchbase.client.core.error.AuthenticationFailureException;
import com.couchbase.client.core.error.BucketExistsException;
import com.couchbase.client.core.error.BucketNotFoundException;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.CollectionExistsException;
import com.couchbase.client.core.error.CollectionNotFoundException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.DocumentNotLockedException;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.IndexExistsException;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.error.InternalServerFailureException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.core.error.ScopeExistsException;
import com.couchbase.client.core.error.ScopeNotFoundException;
import com.couchbase.client.core.error.TimeoutException;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.error.ValueTooLargeException;
import com.couchbase.client.core.error.context.CancellationErrorContext;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.GenericErrorContext;
import com.couchbase.client.core.error.subdoc.DocumentNotJsonException;
import com.couchbase.client.core.error.subdoc.DocumentTooDeepException;
import com.couchbase.client.core.error.subdoc.PathExistsException;
import com.couchbase.client.core.error.subdoc.PathMismatchException;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.core.error.subdoc.ValueInvalidException;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.retry.ProtostellarRequestBehaviour;
import com.couchbase.client.core.retry.RetryOrchestratorProtostellar;
import com.couchbase.client.core.retry.RetryReason;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreProtostellarErrorHandlingUtil {
    private static final String PRECONDITION_LOCKED = "LOCKED";
    private static final String PRECONDITION_NOT_LOCKED = "NOT_OCKED";
    private static final String PRECONDITION_PATH_MISMATCH = "PATH_MISMATCH";
    private static final String PRECONDITION_DOC_NOT_JSON = "DOC_NOT_JSON";
    private static final String PRECONDITION_DOC_TOO_DEEP = "DOC_TOO_DEEP";
    private static final String PRECONDITION_VALUE_OUT_OF_RANGE = "VALUE_OUT_OF_RANGE";
    private static final String PRECONDITION_VALUE_TOO_LARGE = "VALUE_TOO_LARGE";
    private static final String TYPE_URL_PRECONDITION_FAILURE = "type.googleapis.com/google.rpc.PreconditionFailure";
    private static final String TYPE_URL_RESOURCE_INFO = "type.googleapis.com/google.rpc.ResourceInfo";
    private static final String TYPE_URL_ERROR_INFO = "type.googleapis.com/google.rpc.ErrorInfo";
    private static final String TYPE_URL_DEBUG_INFO = "type.googleapis.com/google.rpc.DebugInfo";
    private static final String TYPE_URL_REQUEST_INFO = "type.googleapis.com/google.rpc.RequestInfo";
    private static final String RESOURCE_TYPE_DOCUMENT = "document";
    private static final String RESOURCE_TYPE_SEARCH_INDEX = "searchindex";
    private static final String RESOURCE_TYPE_QUERY_INDEX = "queryindex";
    private static final String RESOURCE_TYPE_ANALYTICS_INDEX = "analyticsindex";
    private static final String RESOURCE_TYPE_BUCKET = "bucket";
    private static final String RESOURCE_TYPE_SCOPE = "scope";
    private static final String RESOURCE_TYPE_COLLECTION = "collection";
    private static final String RESOURCE_TYPE_PATH = "path";
    private static final String REASON_CAS_MISMATCH = "CAS_MISMATCH";

    private CoreProtostellarErrorHandlingUtil() {
    }

    public static ProtostellarRequestBehaviour convertException(CoreProtostellar core, ProtostellarRequest<?> request, Throwable t) {
        if (t instanceof ExecutionException) {
            return CoreProtostellarErrorHandlingUtil.convertException(core, request, t.getCause());
        }
        if (t instanceof StatusRuntimeException) {
            StatusRuntimeException sre = (StatusRuntimeException)t;
            Status status = StatusProto.fromThrowable(sre);
            return CoreProtostellarErrorHandlingUtil.convertStatus(core, request, sre, status);
        }
        if (t instanceof RuntimeException) {
            return ProtostellarRequestBehaviour.fail((RuntimeException)t);
        }
        return ProtostellarRequestBehaviour.fail(new RuntimeException(t));
    }

    public static ProtostellarRequestBehaviour convertStatus(CoreProtostellar core, ProtostellarRequest<?> request, @Nullable StatusRuntimeException t, Status status) {
        GenericErrorContext context = request.context();
        Status.Code code = Status.Code.UNKNOWN;
        if (t != null) {
            com.couchbase.client.core.deps.io.grpc.Status stat = t.getStatus();
            code = stat.getCode();
            context.put("lastException", t.getMessage());
        } else if (status.getCode() < Status.Code.values().length) {
            code = Status.Code.values()[status.getCode()];
        }
        context.put("server", status.getMessage());
        context.put("details", status.getDetailsCount());
        if (status.getDetailsCount() > 0) {
            for (int i = 0; i < status.getDetailsList().size(); ++i) {
                Any details = status.getDetails(i);
                String typeUrl = details.getTypeUrl();
                try {
                    GeneratedMessageV3 info;
                    HashMap<String, Object> detail;
                    if (typeUrl.equals(TYPE_URL_DEBUG_INFO)) {
                        detail = new HashMap<String, Object>();
                        info = DebugInfo.parseFrom(details.getValue());
                        detail.put("detail", ((DebugInfo)info).getDetail());
                        detail.put("stackTrace", ((DebugInfo)info).getStackEntriesList().asByteStringList().stream().map(ByteString::toStringUtf8).collect(Collectors.toList()));
                        context.put("debugInfo", detail);
                        continue;
                    }
                    if (!typeUrl.equals(TYPE_URL_REQUEST_INFO)) continue;
                    detail = new HashMap();
                    info = RequestInfo.parseFrom(details.getValue());
                    detail.put("requestId", ((RequestInfo)info).getRequestId());
                    detail.put("servingData", ((RequestInfo)info).getServingData());
                    context.put("requestInfo", detail);
                    continue;
                }
                catch (InvalidProtocolBufferException detail) {
                    // empty catch block
                }
            }
            Any details = status.getDetails(0);
            String typeUrl = details.getTypeUrl();
            try {
                GeneratedMessageV3 info;
                if (typeUrl.equals(TYPE_URL_PRECONDITION_FAILURE)) {
                    info = PreconditionFailure.parseFrom(details.getValue());
                    if (((PreconditionFailure)info).getViolationsCount() > 0) {
                        PreconditionFailure.Violation violation = ((PreconditionFailure)info).getViolations(0);
                        String type = violation.getType();
                        if (type.equals(PRECONDITION_LOCKED)) {
                            return RetryOrchestratorProtostellar.shouldRetry(core, request, RetryReason.KV_LOCKED);
                        }
                        if (type.equals(PRECONDITION_NOT_LOCKED)) {
                            return ProtostellarRequestBehaviour.fail(new DocumentNotLockedException(context));
                        }
                        if (type.equals(PRECONDITION_PATH_MISMATCH)) {
                            return ProtostellarRequestBehaviour.fail(new PathMismatchException(context));
                        }
                        if (type.equals(PRECONDITION_DOC_NOT_JSON)) {
                            return ProtostellarRequestBehaviour.fail(new DocumentNotJsonException(context));
                        }
                        if (type.equals(PRECONDITION_DOC_TOO_DEEP)) {
                            return ProtostellarRequestBehaviour.fail(new DocumentTooDeepException(context));
                        }
                        if (type.equals(PRECONDITION_VALUE_OUT_OF_RANGE)) {
                            return ProtostellarRequestBehaviour.fail(new ValueInvalidException(context));
                        }
                        if (type.equals(PRECONDITION_VALUE_TOO_LARGE)) {
                            return ProtostellarRequestBehaviour.fail(new ValueTooLargeException(context));
                        }
                    }
                } else if (typeUrl.equals(TYPE_URL_RESOURCE_INFO)) {
                    info = ResourceInfo.parseFrom(details.getValue());
                    String resourceName = ((ResourceInfo)info).getResourceName();
                    String resourceType = ((ResourceInfo)info).getResourceType();
                    if (resourceName != null) {
                        context.put("resourceName", ((ResourceInfo)info).getResourceName());
                    }
                    context.put("resourceType", ((ResourceInfo)info).getResourceType());
                    if (code == Status.Code.NOT_FOUND) {
                        if (resourceType.equals(RESOURCE_TYPE_DOCUMENT)) {
                            return ProtostellarRequestBehaviour.fail(new DocumentNotFoundException(context));
                        }
                        if (resourceType.equals(RESOURCE_TYPE_QUERY_INDEX) || resourceType.equals(RESOURCE_TYPE_SEARCH_INDEX) || resourceType.equals(RESOURCE_TYPE_ANALYTICS_INDEX)) {
                            return ProtostellarRequestBehaviour.fail(IndexNotFoundException.withMessageAndErrorContext(status.getMessage(), context));
                        }
                        if (resourceType.equals(RESOURCE_TYPE_BUCKET)) {
                            return ProtostellarRequestBehaviour.fail(new BucketNotFoundException(((ResourceInfo)info).getResourceName(), context));
                        }
                        if (resourceType.equals(RESOURCE_TYPE_SCOPE)) {
                            return ProtostellarRequestBehaviour.fail(new ScopeNotFoundException(((ResourceInfo)info).getResourceName(), context));
                        }
                        if (resourceType.equals(RESOURCE_TYPE_COLLECTION)) {
                            return ProtostellarRequestBehaviour.fail(new CollectionNotFoundException(((ResourceInfo)info).getResourceName(), context));
                        }
                        if (resourceType.equals(RESOURCE_TYPE_PATH)) {
                            return ProtostellarRequestBehaviour.fail(new PathNotFoundException(null));
                        }
                    } else if (code == Status.Code.ALREADY_EXISTS) {
                        if (resourceType.equals(RESOURCE_TYPE_DOCUMENT)) {
                            return ProtostellarRequestBehaviour.fail(new DocumentExistsException(context));
                        }
                        if (resourceType.equals(RESOURCE_TYPE_QUERY_INDEX) || resourceType.equals(RESOURCE_TYPE_SEARCH_INDEX) || resourceType.equals(RESOURCE_TYPE_ANALYTICS_INDEX)) {
                            return ProtostellarRequestBehaviour.fail(new IndexExistsException(status.getMessage(), context));
                        }
                        if (resourceType.equals(RESOURCE_TYPE_BUCKET)) {
                            return ProtostellarRequestBehaviour.fail(new BucketExistsException(((ResourceInfo)info).getResourceName(), context));
                        }
                        if (resourceType.equals(RESOURCE_TYPE_SCOPE)) {
                            return ProtostellarRequestBehaviour.fail(new ScopeExistsException(((ResourceInfo)info).getResourceName(), context));
                        }
                        if (resourceType.equals(RESOURCE_TYPE_COLLECTION)) {
                            return ProtostellarRequestBehaviour.fail(new CollectionExistsException(((ResourceInfo)info).getResourceName(), context));
                        }
                        if (resourceType.equals(RESOURCE_TYPE_PATH)) {
                            return ProtostellarRequestBehaviour.fail(new PathExistsException(context));
                        }
                    }
                } else if (typeUrl.equals(TYPE_URL_ERROR_INFO)) {
                    info = ErrorInfo.parseFrom(details.getValue());
                    String reason = ((ErrorInfo)info).getReason();
                    context.put("reason", reason);
                    if (code == Status.Code.ABORTED && reason.equals(REASON_CAS_MISMATCH)) {
                        return ProtostellarRequestBehaviour.fail(new CasMismatchException(context));
                    }
                }
            }
            catch (InvalidProtocolBufferException e) {
                return ProtostellarRequestBehaviour.fail(new DecodingFailureException("Failed to decode GRPC response", e));
            }
        }
        switch (code) {
            case CANCELLED: {
                return ProtostellarRequestBehaviour.fail(new RequestCanceledException("Request cancelled by server", CancellationReason.SERVER_CANCELLED, t, new CancellationErrorContext(context)));
            }
            case ABORTED: 
            case UNKNOWN: 
            case INTERNAL: {
                return ProtostellarRequestBehaviour.fail(new InternalServerFailureException(t, (ErrorContext)context));
            }
            case OUT_OF_RANGE: 
            case INVALID_ARGUMENT: {
                return ProtostellarRequestBehaviour.fail(new InvalidArgumentException("Invalid argument provided", t, context));
            }
            case DEADLINE_EXCEEDED: {
                CancellationErrorContext ec = new CancellationErrorContext(context);
                TimeoutException e = request.readonly() ? new UnambiguousTimeoutException("The operation timed out possibly after being sent, and is read-only", ec) : new AmbiguousTimeoutException("The operation timed out possibly after being sent, and state could have been changed on the server as a result", ec);
                return ProtostellarRequestBehaviour.fail(e);
            }
            case NOT_FOUND: {
                return ProtostellarRequestBehaviour.fail(new DocumentNotFoundException(context));
            }
            case ALREADY_EXISTS: {
                return ProtostellarRequestBehaviour.fail(new DocumentExistsException(context));
            }
            case UNAUTHENTICATED: 
            case PERMISSION_DENIED: {
                return ProtostellarRequestBehaviour.fail(new AuthenticationFailureException("Server reported that permission to the resource was denied", context, t));
            }
            case UNIMPLEMENTED: {
                return ProtostellarRequestBehaviour.fail(new FeatureNotAvailableException(status.getMessage(), t));
            }
            case UNAVAILABLE: {
                return RetryOrchestratorProtostellar.shouldRetry(core, request, RetryReason.SERVICE_NOT_AVAILABLE);
            }
            case OK: {
                return ProtostellarRequestBehaviour.success();
            }
        }
        return ProtostellarRequestBehaviour.fail(new CouchbaseException(status.getMessage(), t, context));
    }
}

