/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.endpoint.ProtostellarEndpoint;
import com.couchbase.client.core.protostellar.ProtostellarContext;
import com.couchbase.client.core.util.HostAndPort;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

@Stability.Internal
public class ProtostellarPool {
    private final List<ProtostellarEndpoint> endpoints;
    private final AtomicLong lastUsed = new AtomicLong(0L);

    public ProtostellarPool(ProtostellarContext ctx, HostAndPort remote) {
        int numEndpoints = Integer.parseInt(System.getProperty("com.couchbase.protostellar.numEndpoints", "1"));
        ArrayList<ProtostellarEndpoint> endpoints = new ArrayList<ProtostellarEndpoint>(numEndpoints);
        for (int i = 0; i < numEndpoints; ++i) {
            endpoints.add(new ProtostellarEndpoint(ctx, remote));
        }
        this.endpoints = Collections.unmodifiableList(endpoints);
    }

    public void shutdown(Duration timeout) {
        this.endpoints.forEach(endpoint -> endpoint.shutdown(timeout));
    }

    public ProtostellarEndpoint endpoint() {
        int index = (int)((this.lastUsed.getAndIncrement() & Long.MAX_VALUE) % (long)this.endpoints.size());
        return this.endpoints.get(index);
    }

    public List<ProtostellarEndpoint> endpoints() {
        return this.endpoints;
    }
}

