/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error.context;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Map;
import java.util.Optional;

@Stability.Uncommitted
public class ReducedKeyValueErrorContext
extends ErrorContext {
    private final String id;
    private final CollectionIdentifier collectionIdentifier;

    protected ReducedKeyValueErrorContext(String id, CollectionIdentifier collectionIdentifier) {
        super(null);
        this.id = id;
        this.collectionIdentifier = collectionIdentifier;
    }

    public static ReducedKeyValueErrorContext create(String id, CollectionIdentifier collectionIdentifier) {
        return new ReducedKeyValueErrorContext(id, collectionIdentifier);
    }

    public static ReducedKeyValueErrorContext create(String id, String bucket, String scope, String collection) {
        return new ReducedKeyValueErrorContext(id, new CollectionIdentifier(bucket, Optional.ofNullable(scope), Optional.ofNullable(collection)));
    }

    public static ReducedKeyValueErrorContext create(String id) {
        return new ReducedKeyValueErrorContext(id, null);
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        super.injectExportableParams(input);
        if (this.id != null && !this.id.isEmpty()) {
            input.put("documentId", RedactableArgument.redactUser(this.id));
        }
        if (this.collectionIdentifier != null) {
            input.put("bucket", RedactableArgument.redactMeta(this.collectionIdentifier.bucket()));
            input.put("scope", RedactableArgument.redactMeta(this.collectionIdentifier.scope().orElse("_default")));
            input.put("collection", RedactableArgument.redactMeta(this.collectionIdentifier.collection().orElse("_default")));
        }
    }
}

