/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.endpoint.EventingEndpoint;
import com.couchbase.client.core.service.EndpointSelectionStrategy;
import com.couchbase.client.core.service.PooledService;
import com.couchbase.client.core.service.ServiceConfig;
import com.couchbase.client.core.service.ServiceContext;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.service.strategy.RoundRobinSelectionStrategy;
import java.time.Duration;
import java.util.Optional;

public class EventingService
extends PooledService {
    private final String hostname;
    private final int port;

    public EventingService(CoreContext coreContext, String hostname, int port) {
        super(new EventingServiceConfig(), new ServiceContext(coreContext, hostname, port, ServiceType.EVENTING, Optional.empty()));
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    protected Endpoint createEndpoint() {
        return new EventingEndpoint(this.serviceContext(), this.hostname, this.port);
    }

    @Override
    protected EndpointSelectionStrategy selectionStrategy() {
        return new RoundRobinSelectionStrategy();
    }

    @Override
    public ServiceType type() {
        return ServiceType.EVENTING;
    }

    static class EventingServiceConfig
    implements ServiceConfig {
        EventingServiceConfig() {
        }

        @Override
        public int minEndpoints() {
            return 0;
        }

        @Override
        public int maxEndpoints() {
            return 16;
        }

        @Override
        public Duration idleTime() {
            return Duration.ofSeconds(60L);
        }

        @Override
        public boolean pipelined() {
            return false;
        }
    }
}

