/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DocumentLockedException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.DurabilityAmbiguousException;
import com.couchbase.client.core.error.DurabilityImpossibleException;
import com.couchbase.client.core.error.DurabilityLevelNotAvailableException;
import com.couchbase.client.core.error.DurableWriteInProgressException;
import com.couchbase.client.core.error.DurableWriteReCommitInProgressException;
import com.couchbase.client.core.error.InternalServerFailureException;
import com.couchbase.client.core.error.ServerOutOfMemoryException;
import com.couchbase.client.core.error.TemporaryFailureException;
import com.couchbase.client.core.error.ValueTooLargeException;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.kv.KeyValueRequest;

@Stability.Internal
public class DefaultErrorUtil {
    private DefaultErrorUtil() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static CouchbaseException keyValueStatusToException(KeyValueRequest<? extends Response> request, Response response) {
        KeyValueErrorContext ctx = KeyValueErrorContext.completedRequest(request, response.status());
        switch (response.status()) {
            case DURABILITY_INVALID_LEVEL: {
                return new DurabilityLevelNotAvailableException(ctx);
            }
            case DURABILITY_IMPOSSIBLE: {
                return new DurabilityImpossibleException(ctx);
            }
            case EXISTS: {
                return new CasMismatchException(ctx);
            }
            case LOCKED: {
                return new DocumentLockedException(ctx);
            }
            case NOT_FOUND: {
                return new DocumentNotFoundException(ctx);
            }
            case NOT_STORED: {
                return new DocumentNotFoundException(ctx);
            }
            case OUT_OF_MEMORY: {
                return new ServerOutOfMemoryException(ctx);
            }
            case SERVER_BUSY: {
                return new TemporaryFailureException(ctx);
            }
            case SYNC_WRITE_AMBIGUOUS: {
                return new DurabilityAmbiguousException(ctx);
            }
            case SYNC_WRITE_IN_PROGRESS: {
                return new DurableWriteInProgressException(ctx);
            }
            case SYNC_WRITE_RE_COMMIT_IN_PROGRESS: {
                return new DurableWriteReCommitInProgressException(ctx);
            }
            case TEMPORARY_FAILURE: {
                return new TemporaryFailureException(ctx);
            }
            case TOO_BIG: {
                return new ValueTooLargeException(ctx);
            }
            case INTERNAL_SERVER_ERROR: {
                return new InternalServerFailureException(ctx);
            }
        }
        return new CouchbaseException(request.getClass().getSimpleName() + " failed with unexpected status code " + (Object)((Object)response.status()), ctx);
    }
}

