/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.util.CbStrings;
import java.util.Objects;

@Stability.Volatile
public class CollectionNotFoundException
extends CouchbaseException {
    private final String collectionName;

    public CollectionNotFoundException(String collectionName) {
        this(collectionName, (ErrorContext)null);
    }

    public CollectionNotFoundException(String collectionName, ErrorContext errorContext) {
        super("Collection" + CollectionNotFoundException.formatCollection(collectionName) + " not found.", errorContext);
        this.collectionName = Objects.requireNonNull(collectionName);
    }

    private static String formatCollection(String collectionName) {
        return CbStrings.isNullOrEmpty(collectionName) ? "" : " [" + RedactableArgument.redactMeta(collectionName) + "]";
    }

    public static CollectionNotFoundException forCollection(String collectionName) {
        return new CollectionNotFoundException(collectionName);
    }

    public String collectionName() {
        return this.collectionName;
    }
}

