/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.env.AbstractMapPropertyLoader;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.util.ConnectionString;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ConnectionStringPropertyLoader
extends AbstractMapPropertyLoader<CoreEnvironment.Builder> {
    private final ConnectionString connectionString;
    private static final Map<String, String> COMPAT_ALIAS = new HashMap<String, String>();

    public ConnectionStringPropertyLoader(String connectionString) {
        this.connectionString = ConnectionString.create(connectionString);
    }

    @Override
    protected Map<String, String> propertyMap() {
        Map<String, String> properties = this.connectionString.params().entrySet().stream().collect(Collectors.toMap(entry -> COMPAT_ALIAS.getOrDefault(entry.getKey(), (String)entry.getKey()), Map.Entry::getValue));
        if (this.connectionString.scheme() == ConnectionString.Scheme.COUCHBASES) {
            properties.put("security.enableTls", "true");
        }
        return properties;
    }

    static {
        COMPAT_ALIAS.put("certpath", "security.trustCertificate");
    }
}

