/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import java.util.Optional;

public interface SyncDurabilityRequest {
    public Optional<DurabilityLevel> durabilityLevel();

    default public void applyLevelOnSpan(Optional<DurabilityLevel> level, RequestSpan span) {
        if (level.isPresent() && span != null) {
            switch (level.get()) {
                case MAJORITY: {
                    span.attribute("db.couchbase.durability", "majority");
                }
                case MAJORITY_AND_PERSIST_TO_ACTIVE: {
                    span.attribute("db.couchbase.durability", "majority_and_persist_active");
                }
                case PERSIST_TO_MAJORITY: {
                    span.attribute("db.couchbase.durability", "persist_majority");
                }
            }
        }
    }
}

