/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.service.ServiceType;
import java.util.Objects;

@Stability.Internal
public class RequestTarget {
    private final ServiceType serviceType;
    private final NodeIdentifier nodeIdentifier;
    private final String bucketName;

    public static RequestTarget views(String bucket) {
        return new RequestTarget(ServiceType.VIEWS, null, bucket);
    }

    public static RequestTarget manager() {
        return new RequestTarget(ServiceType.MANAGER, null, null);
    }

    public static RequestTarget query() {
        return new RequestTarget(ServiceType.QUERY, null, null);
    }

    public static RequestTarget analytics() {
        return new RequestTarget(ServiceType.ANALYTICS, null, null);
    }

    public static RequestTarget search() {
        return new RequestTarget(ServiceType.SEARCH, null, null);
    }

    public static RequestTarget eventing() {
        return new RequestTarget(ServiceType.EVENTING, null, null);
    }

    public RequestTarget(ServiceType serviceType, NodeIdentifier nodeIdentifier, String bucketName) {
        this.serviceType = Objects.requireNonNull(serviceType);
        this.nodeIdentifier = nodeIdentifier;
        this.bucketName = bucketName;
    }

    public RequestTarget withNodeIdentifier(NodeIdentifier nodeIdentifier) {
        return new RequestTarget(this.serviceType, nodeIdentifier, this.bucketName);
    }

    public ServiceType serviceType() {
        return this.serviceType;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public NodeIdentifier nodeIdentifier() {
        return this.nodeIdentifier;
    }

    public String toString() {
        return "RequestTarget{serviceType=" + (Object)((Object)this.serviceType) + ", nodeIdentifier=" + RedactableArgument.redactSystem(this.nodeIdentifier) + ", bucketName='" + RedactableArgument.redactMeta(this.bucketName) + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestTarget that = (RequestTarget)o;
        return this.serviceType == that.serviceType && Objects.equals(this.nodeIdentifier, that.nodeIdentifier) && Objects.equals(this.bucketName, that.bucketName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.serviceType, this.nodeIdentifier, this.bucketName});
    }
}

