/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.manager;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpResponseStatus;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpClient;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpResponse;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DesignDocumentNotFoundException;
import com.couchbase.client.core.error.HttpStatusCodeException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.context.ReducedViewErrorContext;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.manager.AbstractManagerSupport;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.core.util.Validators;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@Stability.Internal
public class CoreViewIndexManager {
    private static final String DEV_PREFIX = "dev_";
    protected final Core core;
    private final String bucket;
    protected final CoreHttpClient viewService;

    public static String requireUnqualifiedName(String name) {
        if (name.startsWith(DEV_PREFIX)) {
            throw InvalidArgumentException.fromMessage("Design document name '" + RedactableArgument.redactMeta(name) + "' must not start with '" + DEV_PREFIX + "'; instead specify the " + CoreViewIndexManager.namespaceToString(false) + " namespace when referring to the document.");
        }
        return name;
    }

    public CoreViewIndexManager(Core core, String bucket) {
        this.core = Objects.requireNonNull(core);
        this.bucket = Objects.requireNonNull(bucket);
        this.viewService = core.httpClient(RequestTarget.views(bucket));
    }

    private static String adjustName(String name, boolean production) {
        if (production) {
            return CbStrings.removeStart(name, DEV_PREFIX);
        }
        return name.startsWith(DEV_PREFIX) ? name : DEV_PREFIX + name;
    }

    private CoreHttpPath pathForDesignDocument(String name, boolean production) {
        return CoreHttpPath.path("/{bucket}/_design/{ddoc}", CbCollections.mapOf("bucket", this.bucket, "ddoc", CoreViewIndexManager.adjustName(name, production)));
    }

    private String pathForAllDesignDocuments() {
        return "/pools/default/buckets/" + UrlQueryStringBuilder.urlEncode(this.bucket) + "/ddocs";
    }

    public CompletableFuture<Map<String, ObjectNode>> getAllDesignDocuments(boolean production, CoreCommonOptions options) {
        RequestSpan span = this.buildSpan("manager_views_get_all_design_documents", options.parentSpan());
        span.attribute("db.name", this.bucket);
        Duration timeout = options.timeout().orElse(this.core.context().environment().timeoutConfig().managementTimeout());
        RetryStrategy retryStrategy = options.retryStrategy().orElse(null);
        return new ConfigManager().sendRequest(HttpMethod.GET, this.pathForAllDesignDocuments(), timeout, retryStrategy, span).thenApply(response -> {
            if (response.status() != ResponseStatus.SUCCESS) {
                throw new CouchbaseException("Failed to get all design documents; response status=" + (Object)((Object)response.status()) + "; response body=" + new String(response.content(), StandardCharsets.UTF_8));
            }
            return CoreViewIndexManager.parseAllDesignDocuments(Mapper.decodeIntoTree(response.content()), production);
        });
    }

    private static Map<String, ObjectNode> parseAllDesignDocuments(JsonNode node, boolean production) {
        LinkedHashMap<String, ObjectNode> result = new LinkedHashMap<String, ObjectNode>();
        node.get("rows").forEach(row -> {
            String metaId = row.path("doc").path("meta").path("id").asText();
            String ddocName = CbStrings.removeStart(metaId, "_design/");
            if (CoreViewIndexManager.namespaceContainsName(ddocName, production)) {
                JsonNode ddocDef = row.path("doc").path("json");
                result.put(ddocName, (ObjectNode)ddocDef);
            }
        });
        return result;
    }

    private static boolean namespaceContainsName(String name, boolean production) {
        return production && !name.startsWith(DEV_PREFIX) || !production && name.startsWith(DEV_PREFIX);
    }

    public CompletableFuture<byte[]> getDesignDocument(String name, boolean production, CoreCommonOptions options) {
        Validators.notNullOrEmpty(name, "Name", () -> new ReducedViewErrorContext(null, null, this.bucket));
        return ((CompletableFuture)this.viewService.get(this.pathForDesignDocument(name, production), options).trace("manager_views_get_design_document").exec(this.core).exceptionally(t -> {
            String namespace = CoreViewIndexManager.namespaceToString(production);
            throw CoreViewIndexManager.notFound(t) ? DesignDocumentNotFoundException.forName(name, namespace) : new CouchbaseException("Failed to get design document [" + RedactableArgument.redactMeta(name) + "] from namespace " + namespace, (Throwable)t);
        })).thenApply(CoreHttpResponse::content);
    }

    private static String namespaceToString(boolean production) {
        return production ? "PRODUCTION" : "DEVELOPMENT";
    }

    public CompletableFuture<Void> upsertDesignDocument(String docName, byte[] doc, boolean production, CoreCommonOptions options) {
        Validators.notNull(doc, "DesignDocument", () -> new ReducedViewErrorContext(null, null, this.bucket));
        return this.viewService.put(this.pathForDesignDocument(docName, production), options).json(doc).trace("manager_views_upsert_design_document").exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<Void> publishDesignDocument(String name, CoreCommonOptions options) {
        Validators.notNullOrEmpty(name, "Name", () -> new ReducedViewErrorContext(null, null, this.bucket));
        RequestSpan span = this.buildSpan("manager_views_publish_design_document", options.parentSpan());
        CoreCommonOptions childOptions = options.withParentSpan(span);
        return ((CompletableFuture)this.getDesignDocument(name, false, childOptions).thenCompose(doc -> this.upsertDesignDocument(name, (byte[])doc, true, childOptions))).whenComplete((r, t) -> span.end());
    }

    public CompletableFuture<Void> dropDesignDocument(String name, boolean production, CoreCommonOptions options) {
        Validators.notNullOrEmpty(name, "Name", () -> new ReducedViewErrorContext(null, null, this.bucket));
        return ((CompletableFuture)this.viewService.delete(this.pathForDesignDocument(name, production), options).trace("manager_views_drop_design_document").exec(this.core).exceptionally(t -> {
            String namespace = CoreViewIndexManager.namespaceToString(production);
            if (CoreViewIndexManager.notFound(t)) {
                throw DesignDocumentNotFoundException.forName(name, namespace);
            }
            throw new CouchbaseException("Failed to drop design document [" + RedactableArgument.redactMeta(name) + "] from namespace " + namespace, (Throwable)t);
        })).thenApply(response -> null);
    }

    private static boolean notFound(Throwable t) {
        return CoreViewIndexManager.getHttpStatusCode(t) == HttpResponseStatus.NOT_FOUND.code();
    }

    private static int getHttpStatusCode(Throwable t) {
        return CbThrowables.findCause(t, HttpStatusCodeException.class).map(HttpStatusCodeException::code).orElse(0);
    }

    private RequestSpan buildSpan(String spanName, Optional<RequestSpan> parent) {
        return CbTracing.newSpan(this.core.context(), spanName, (RequestSpan)parent.orElse(null));
    }

    private class ConfigManager
    extends AbstractManagerSupport {
        public ConfigManager() {
            super(CoreViewIndexManager.this.core);
        }
    }
}

