/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;

@Stability.Volatile
public class ScopeNotFoundException
extends CouchbaseException {
    private final String scopeName;

    public ScopeNotFoundException(String scopeName) {
        super("Scope [" + RedactableArgument.redactMeta(scopeName) + "] not found.");
        this.scopeName = Objects.requireNonNull(scopeName);
    }

    public static ScopeNotFoundException forScope(String scopeName) {
        return new ScopeNotFoundException(scopeName);
    }

    public String scopeName() {
        return this.scopeName;
    }
}

