/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;

@Stability.Volatile
public class AggregatingMeterConfig {
    private final Duration emitInterval;
    private final boolean enabled;

    public static Builder builder() {
        return new Builder();
    }

    public static AggregatingMeterConfig create() {
        return AggregatingMeterConfig.builder().build();
    }

    public static AggregatingMeterConfig disabled() {
        return AggregatingMeterConfig.enabled(false).build();
    }

    AggregatingMeterConfig(Builder builder) {
        this.emitInterval = builder.emitInterval;
        this.enabled = builder.enabled;
    }

    public static Builder emitInterval(Duration emitInterval) {
        return AggregatingMeterConfig.builder().emitInterval(emitInterval);
    }

    public static Builder enabled(boolean enabled) {
        return AggregatingMeterConfig.builder().enabled(enabled);
    }

    public Duration emitInterval() {
        return this.emitInterval;
    }

    public boolean enabled() {
        return this.enabled;
    }

    @Stability.Volatile
    Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("enabled", this.enabled);
        export.put("emitIntervalMs", this.emitInterval.toMillis());
        return export;
    }

    public static class Builder {
        private Duration emitInterval = Defaults.DEFAULT_EMIT_INTERVAL;
        private boolean enabled = true;

        public Builder emitInterval(Duration emitInterval) {
            if (emitInterval.isZero()) {
                throw InvalidArgumentException.fromMessage("Emit interval must be greater than 0");
            }
            this.emitInterval = emitInterval;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public AggregatingMeterConfig build() {
            return new AggregatingMeterConfig(this);
        }
    }

    @Stability.Internal
    public static class Defaults {
        public static final boolean DEFAULT_ENABLED = true;
        public static final Duration DEFAULT_EMIT_INTERVAL = Duration.ofSeconds(600L);
    }
}

