/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.service.ServiceType;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

@Stability.Internal
public class CbTracing {
    private static final Map<ServiceType, String> serviceTypeToTracingId;

    private CbTracing() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static RequestSpan newSpan(CoreContext coreContext, String spanName, RequestSpan parent) {
        return CbTracing.newSpan(coreContext.environment().requestTracer(), spanName, parent);
    }

    public static RequestSpan newSpan(RequestTracer tracer, String spanName, RequestSpan parent) {
        RequestSpan span = tracer.requestSpan(spanName, parent);
        span.attribute("db.system", "couchbase");
        return span;
    }

    public static String getTracingId(ServiceType serviceType) {
        return serviceTypeToTracingId.getOrDefault((Object)serviceType, serviceType.ident());
    }

    static {
        EnumMap<ServiceType, String> map = new EnumMap<ServiceType, String>(ServiceType.class);
        map.put(ServiceType.ANALYTICS, "analytics");
        map.put(ServiceType.EVENTING, "eventing");
        map.put(ServiceType.KV, "kv");
        map.put(ServiceType.MANAGER, "management");
        map.put(ServiceType.QUERY, "query");
        map.put(ServiceType.SEARCH, "search");
        map.put(ServiceType.VIEWS, "views");
        serviceTypeToTracingId = Collections.unmodifiableMap(map);
    }
}

