/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.util.Stateful;
import com.couchbase.client.core.util.Validators;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.ReplayProcessor;

public class SingleStateful<S>
implements Stateful<S> {
    private final ReplayProcessor<S> states = ReplayProcessor.cacheLast();
    private final FluxSink<S> statesSink = this.states.sink();
    private final AtomicReference<S> currentState;
    private final BiConsumer<S, S> beforeTransitionCallback;

    private SingleStateful(S initialState, BiConsumer<S, S> beforeTransitionCallback) {
        Validators.notNull(initialState, "Initial Stateful Type");
        this.currentState = new AtomicReference<S>(initialState);
        this.beforeTransitionCallback = beforeTransitionCallback;
        this.statesSink.next(initialState);
    }

    public static <S> SingleStateful<S> fromInitial(S initialState) {
        return SingleStateful.fromInitial(initialState, (oldState, newState) -> {});
    }

    public static <S> SingleStateful<S> fromInitial(S initialState, BiConsumer<S, S> beforeTransitionCallback) {
        return new SingleStateful<S>(initialState, beforeTransitionCallback);
    }

    @Override
    public S state() {
        return this.currentState.get();
    }

    @Override
    public Flux<S> states() {
        return this.states;
    }

    public synchronized void transition(S newState) {
        Validators.notNull(newState, "New Stateful Type");
        if (!this.currentState.get().equals(newState)) {
            this.beforeTransitionCallback.accept(this.currentState.get(), newState);
            this.currentState.set(newState);
            this.statesSink.next(newState);
        }
    }

    public boolean compareAndTransition(S expectedState, S newState) {
        Validators.notNull(newState, "New Stateful Type");
        Validators.notNull(expectedState, "Expected Stateful Type");
        if (this.currentState.compareAndSet(expectedState, newState)) {
            this.beforeTransitionCallback.accept(expectedState, newState);
            this.statesSink.next(newState);
            return true;
        }
        return false;
    }

    public void close() {
        this.statesSink.complete();
    }
}

