/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.search;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpResponse;
import com.couchbase.client.core.io.netty.HttpChannelContext;
import com.couchbase.client.core.io.netty.HttpProtocol;
import com.couchbase.client.core.msg.BaseRequest;
import com.couchbase.client.core.msg.NonChunkedHttpRequest;
import com.couchbase.client.core.msg.search.GenericSearchResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;

public class GenericSearchRequest
extends BaseRequest<GenericSearchResponse>
implements NonChunkedHttpRequest<GenericSearchResponse> {
    private final Supplier<FullHttpRequest> requestSupplier;
    private final boolean idempotent;

    public GenericSearchRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, Supplier<FullHttpRequest> requestSupplier, boolean idempotent, RequestSpan span) {
        super(timeout, ctx, retryStrategy);
        this.requestSupplier = Objects.requireNonNull(requestSupplier);
        this.idempotent = idempotent;
        if (span != null) {
            span.setAttribute("db.couchbase.service", "search");
            FullHttpRequest request = requestSupplier.get();
            span.setAttribute("db.operation", request.method().toString() + " " + request.uri());
        }
    }

    @Override
    public GenericSearchResponse decode(FullHttpResponse response, HttpChannelContext context) {
        byte[] dst = ByteBufUtil.getBytes(response.content());
        return new GenericSearchResponse(HttpProtocol.decodeStatus(response.status()), dst);
    }

    @Override
    public FullHttpRequest encode() {
        FullHttpRequest request = this.requestSupplier.get();
        this.context().authenticator().authHttpRequest(this.serviceType(), request);
        return request;
    }

    @Override
    public ServiceType serviceType() {
        return ServiceType.SEARCH;
    }

    @Override
    public boolean idempotent() {
        return this.idempotent;
    }
}

