/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.Validators;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@Stability.Internal
public class MutationTokenAggregator
implements Iterable<MutationToken> {
    private final ConcurrentHashMap<BucketAndPartition, MutationToken> tokens = new ConcurrentHashMap();

    @Override
    public Iterator<MutationToken> iterator() {
        return this.tokens.values().iterator();
    }

    public String toString() {
        return this.tokens.values().toString();
    }

    public void add(MutationToken token) {
        Validators.notNull(token, "token");
        BucketAndPartition key = new BucketAndPartition(token.bucketName(), token.partitionID());
        this.tokens.compute(key, (bucketAndPartition, exitingToken) -> {
            if (exitingToken == null || Long.compareUnsigned(token.sequenceNumber(), exitingToken.sequenceNumber()) >= 0) {
                return token;
            }
            return exitingToken;
        });
    }

    public Map<String, ?> export() {
        HashMap<String, Map> result = new HashMap<String, Map>();
        for (MutationToken token : this) {
            Map bucket = result.computeIfAbsent(token.bucketName(), key -> new HashMap());
            bucket.put(String.valueOf(token.partitionID()), CbCollections.listOf(token.sequenceNumber(), String.valueOf(token.partitionUUID())));
        }
        return result;
    }

    public Map<String, ?> exportForSearch() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (MutationToken token : this) {
            String tokenKey = token.partitionID() + "/" + token.partitionUUID();
            result.put(tokenKey, token.sequenceNumber());
        }
        return result;
    }

    public static MutationTokenAggregator from(Map<String, ?> source) {
        try {
            MutationTokenAggregator state = new MutationTokenAggregator();
            for (String bucketName : source.keySet()) {
                Map bucket = (Map)source.get(bucketName);
                for (String vbid : bucket.keySet()) {
                    List values = (List)bucket.get(vbid);
                    state.add(new MutationToken(Short.parseShort(vbid), Long.parseLong((String)values.get(1)), ((Number)values.get(0)).longValue(), bucketName));
                }
            }
            return state;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not import MutationState from JSON.", ex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutationTokenAggregator that = (MutationTokenAggregator)o;
        return this.tokens.equals(that.tokens);
    }

    public int hashCode() {
        return Objects.hash(this.tokens);
    }

    private static class BucketAndPartition {
        private final String bucket;
        private final short partition;

        public BucketAndPartition(String bucket, short partition) {
            this.bucket = Objects.requireNonNull(bucket);
            this.partition = partition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BucketAndPartition key = (BucketAndPartition)o;
            return this.partition == key.partition && this.bucket.equals(key.bucket);
        }

        public int hashCode() {
            return Objects.hash(this.bucket, this.partition);
        }
    }
}

