/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.GetMetaResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;

public class GetMetaRequest
extends BaseKeyValueRequest<GetMetaResponse> {
    public GetMetaRequest(String key, Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, RequestSpan span) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        if (span != null) {
            span.setAttribute("db.operation", "exists");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        ByteBuf extras = null;
        try {
            extras = alloc.buffer(1);
            extras.writeByte(2);
            key = this.encodedKeyWithCollection(alloc, ctx);
            byteBuf = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.GET_META, MemcacheProtocol.noDatatype(), this.partition(), opaque, MemcacheProtocol.noCas(), extras, key, MemcacheProtocol.noBody());
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            ReferenceCountUtil.release(extras);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        ReferenceCountUtil.release(extras);
        return byteBuf;
    }

    @Override
    public GetMetaResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        boolean deleted = MemcacheProtocol.extrasAsInt(response, 0, 0) != 0;
        return new GetMetaResponse(MemcacheProtocol.decodeStatus(response), MemcacheProtocol.cas(response), deleted);
    }

    @Override
    public boolean idempotent() {
        return true;
    }

    @Override
    public String name() {
        return "exists";
    }
}

