/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.env.BuilderPropertySetter;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.PropertyLoader;
import com.couchbase.client.core.error.InvalidArgumentException;
import java.util.Map;

public abstract class AbstractMapPropertyLoader<B extends CoreEnvironment.Builder>
implements PropertyLoader<B> {
    private final BuilderPropertySetter setter = new BuilderPropertySetter();

    protected AbstractMapPropertyLoader() {
    }

    protected abstract Map<String, String> propertyMap();

    @Override
    public void load(B builder) {
        for (Map.Entry<String, String> entry : this.propertyMap().entrySet()) {
            try {
                this.setter.set(builder, entry.getKey(), entry.getValue());
            }
            catch (IllegalArgumentException e) {
                throw InvalidArgumentException.fromMessage("Failed to apply property \"" + entry.getKey() + "\". " + e.getMessage(), e);
            }
        }
    }
}

