/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpClientCodec;
import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.endpoint.PipelineInitializer;
import com.couchbase.client.core.io.netty.view.ViewHandlerSwitcher;
import com.couchbase.client.core.service.ServiceContext;
import com.couchbase.client.core.service.ServiceType;

public class ViewEndpoint
extends BaseEndpoint {
    public ViewEndpoint(ServiceContext ctx, String hostname, int port) {
        super(hostname, port, ctx.environment().ioEnvironment().viewEventLoopGroup().get(), ctx, ctx.environment().ioConfig().viewCircuitBreakerConfig(), ServiceType.VIEWS, false);
    }

    @Override
    protected PipelineInitializer pipelineInitializer() {
        return new ViewPipelineInitializer(this.context());
    }

    public static class ViewPipelineInitializer
    implements PipelineInitializer {
        private final EndpointContext endpointContext;

        ViewPipelineInitializer(EndpointContext endpointContext) {
            this.endpointContext = endpointContext;
        }

        @Override
        public void init(BaseEndpoint endpoint, ChannelPipeline pipeline) {
            pipeline.addLast(new HttpClientCodec());
            pipeline.addLast(ViewHandlerSwitcher.SWITCHER_IDENTIFIER, (ChannelHandler)new ViewHandlerSwitcher(endpoint, this.endpointContext));
        }
    }
}

