/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.TargetedRequest;
import com.couchbase.client.core.msg.UnmonitoredRequest;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.CarrierGlobalConfigResponse;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.Bytes;
import java.time.Duration;
import java.util.Map;

public class CarrierGlobalConfigRequest
extends BaseKeyValueRequest<CarrierGlobalConfigResponse>
implements TargetedRequest,
UnmonitoredRequest {
    private final NodeIdentifier target;

    public CarrierGlobalConfigRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, NodeIdentifier target) {
        super(timeout, ctx, retryStrategy, null, null);
        this.target = target;
    }

    @Override
    public NodeIdentifier target() {
        return this.target;
    }

    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        return MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.GET_CONFIG, MemcacheProtocol.noDatatype(), MemcacheProtocol.noPartition(), opaque, MemcacheProtocol.noCas(), MemcacheProtocol.noExtras(), MemcacheProtocol.noKey(), MemcacheProtocol.noBody());
    }

    @Override
    public CarrierGlobalConfigResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        byte[] content = MemcacheProtocol.body(response).map(ByteBufUtil::getBytes).map(bytes -> MemcacheProtocol.tryDecompression(bytes, MemcacheProtocol.datatype(response))).orElse(Bytes.EMPTY_BYTE_ARRAY);
        return new CarrierGlobalConfigResponse(MemcacheProtocol.decodeStatus(response), content);
    }

    @Override
    public boolean idempotent() {
        return true;
    }

    @Override
    public Map<String, Object> serviceContext() {
        Map<String, Object> ctx = super.serviceContext();
        if (this.target != null) {
            ctx.put("target", RedactableArgument.redactSystem(this.target.address()));
        }
        return ctx;
    }
}

