/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.error.AmbiguousTimeoutException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.error.context.CancellationErrorContext;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class BaseRequest<R extends Response>
implements Request<R> {
    private static final AtomicLong REQUEST_ID = new AtomicLong();
    private static final AtomicReferenceFieldUpdater<BaseRequest, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(BaseRequest.class, State.class, "state");
    private final long id;
    private final Duration timeout;
    private final long absoluteTimeout;
    private final RequestContext ctx;
    private final CompletableFuture<R> response;
    private final RetryStrategy retryStrategy;
    private final RequestSpan requestSpan;
    private final long createdAt;
    private volatile State state = State.INCOMPLETE;
    private volatile CancellationReason cancellationReason;

    public BaseRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy) {
        this(timeout, ctx, retryStrategy, null);
    }

    public BaseRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, RequestSpan requestSpan) {
        if (timeout == null) {
            throw InvalidArgumentException.fromMessage("A Timeout must be provided");
        }
        if (ctx == null) {
            throw InvalidArgumentException.fromMessage("A CoreContext must be provided");
        }
        this.timeout = timeout;
        this.createdAt = System.nanoTime();
        this.absoluteTimeout = this.createdAt + timeout.toNanos();
        this.response = new CompletableFuture();
        this.id = REQUEST_ID.incrementAndGet();
        this.ctx = new RequestContext(ctx, this);
        RetryStrategy retryStrategy2 = this.retryStrategy = retryStrategy == null ? ctx.environment().retryStrategy() : retryStrategy;
        if (requestSpan != null) {
            requestSpan.requestContext(this.ctx);
        }
        this.requestSpan = requestSpan;
    }

    @Override
    public CompletableFuture<R> response() {
        return this.response;
    }

    @Override
    public void succeed(R result) {
        if (STATE_UPDATER.compareAndSet(this, State.INCOMPLETE, State.SUCCEEDED)) {
            this.response.complete(result);
        }
    }

    @Override
    public void fail(Throwable error) {
        if (STATE_UPDATER.compareAndSet(this, State.INCOMPLETE, State.FAILED)) {
            this.response.completeExceptionally(error);
        }
    }

    @Override
    public void cancel(CancellationReason reason) {
        if (STATE_UPDATER.compareAndSet(this, State.INCOMPLETE, State.CANCELLED)) {
            this.cancellationReason = reason;
            String msg = this.getClass().getSimpleName() + ", Reason: " + reason;
            CancellationErrorContext ctx = new CancellationErrorContext(this.context());
            CouchbaseException exception = reason == CancellationReason.TIMEOUT ? (this.idempotent() ? new UnambiguousTimeoutException(msg, ctx) : new AmbiguousTimeoutException(msg, ctx)) : new RequestCanceledException(msg, reason, ctx);
            this.response.completeExceptionally(exception);
        }
    }

    @Override
    public boolean completed() {
        return this.state != State.INCOMPLETE;
    }

    @Override
    public boolean succeeded() {
        return this.state == State.SUCCEEDED;
    }

    @Override
    public boolean failed() {
        return this.state == State.FAILED;
    }

    @Override
    public boolean cancelled() {
        return this.state == State.CANCELLED;
    }

    @Override
    public CancellationReason cancellationReason() {
        return this.cancellationReason;
    }

    @Override
    public RequestContext context() {
        return this.ctx;
    }

    @Override
    public Duration timeout() {
        return this.timeout;
    }

    @Override
    public boolean timeoutElapsed() {
        return this.absoluteTimeout - System.nanoTime() <= 0L;
    }

    @Override
    public long absoluteTimeout() {
        return this.absoluteTimeout;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    @Override
    public Map<String, Object> serviceContext() {
        return null;
    }

    @Override
    public long createdAt() {
        return this.createdAt;
    }

    @Override
    public RequestSpan requestSpan() {
        return this.requestSpan;
    }

    private static enum State {
        INCOMPLETE,
        SUCCEEDED,
        FAILED,
        CANCELLED;

    }
}

