/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.Timer;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.DefaultEventBus;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.LoggingEventConsumer;
import com.couchbase.client.core.cnc.Meter;
import com.couchbase.client.core.cnc.OrphanReporter;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.cnc.events.config.HighIdleHttpConnectionTimeoutConfiguredEvent;
import com.couchbase.client.core.cnc.events.config.InsecureSecurityConfigDetectedEvent;
import com.couchbase.client.core.cnc.metrics.AggregatingMeter;
import com.couchbase.client.core.cnc.metrics.NoopMeter;
import com.couchbase.client.core.cnc.tracing.ThresholdRequestTracer;
import com.couchbase.client.core.deps.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import com.couchbase.client.core.env.AggregatingMeterConfig;
import com.couchbase.client.core.env.CompressionConfig;
import com.couchbase.client.core.env.ExternalSupplier;
import com.couchbase.client.core.env.IoConfig;
import com.couchbase.client.core.env.IoEnvironment;
import com.couchbase.client.core.env.LoggerConfig;
import com.couchbase.client.core.env.OrphanReporterConfig;
import com.couchbase.client.core.env.OwnedSupplier;
import com.couchbase.client.core.env.PropertyLoader;
import com.couchbase.client.core.env.SecurityConfig;
import com.couchbase.client.core.env.SystemPropertyPropertyLoader;
import com.couchbase.client.core.env.ThresholdRequestTracerConfig;
import com.couchbase.client.core.env.TimeoutConfig;
import com.couchbase.client.core.env.UserAgent;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.AbstractPooledEndpointServiceConfig;
import com.couchbase.client.core.util.Validators;
import java.net.URL;
import java.time.Duration;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class CoreEnvironment {
    private static final String CORE_AGENT_TITLE = "java-core";
    public static final long DEFAULT_MAX_NUM_REQUESTS_IN_RETRY = 32768L;
    private static final Map<String, Attributes> MANIFEST_INFOS = new ConcurrentHashMap<String, Attributes>();
    private static final RetryStrategy DEFAULT_RETRY_STRATEGY;
    private final UserAgent userAgent;
    private final Supplier<EventBus> eventBus;
    private final Timer timer;
    private final IoEnvironment ioEnvironment;
    private final IoConfig ioConfig;
    private final CompressionConfig compressionConfig;
    private final SecurityConfig securityConfig;
    private final TimeoutConfig timeoutConfig;
    private final OrphanReporterConfig orphanReporterConfig;
    private final ThresholdRequestTracerConfig thresholdRequestTracerConfig;
    private final AggregatingMeterConfig aggregatingMeterConfig;
    private final Supplier<RequestTracer> requestTracer;
    private final Supplier<Meter> meter;
    private final LoggerConfig loggerConfig;
    private final RetryStrategy retryStrategy;
    private final Supplier<Scheduler> scheduler;
    private final OrphanReporter orphanReporter;
    private final long maxNumRequestsInRetry;

    public static CoreEnvironment create() {
        return CoreEnvironment.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected CoreEnvironment(Builder builder) {
        new SystemPropertyPropertyLoader().load(builder);
        this.userAgent = this.defaultUserAgent();
        this.maxNumRequestsInRetry = builder.maxNumRequestsInRetry;
        this.scheduler = Optional.ofNullable(builder.scheduler).orElse(new OwnedSupplier<Scheduler>(Schedulers.newParallel((String)"cb-comp", (int)Schedulers.DEFAULT_POOL_SIZE, (boolean)true)));
        this.eventBus = Optional.ofNullable(builder.eventBus).orElse(new OwnedSupplier<DefaultEventBus>(DefaultEventBus.create(this.scheduler.get())));
        this.timer = Timer.createAndStart(this.maxNumRequestsInRetry);
        this.securityConfig = builder.securityConfig.build();
        this.ioEnvironment = builder.ioEnvironment.build();
        this.ioConfig = builder.ioConfig.build();
        this.compressionConfig = builder.compressionConfig.build();
        this.timeoutConfig = builder.timeoutConfig.build();
        this.retryStrategy = Optional.ofNullable(builder.retryStrategy).orElse(DEFAULT_RETRY_STRATEGY);
        this.loggerConfig = builder.loggerConfig.build();
        this.orphanReporterConfig = builder.orphanReporterConfig.build();
        this.thresholdRequestTracerConfig = builder.thresholdRequestTracerConfig.build();
        this.aggregatingMeterConfig = builder.aggregatingMeterConfig.build();
        if (this.eventBus instanceof OwnedSupplier) {
            this.eventBus.get().start().block();
        }
        this.eventBus.get().subscribe(LoggingEventConsumer.create(this.loggerConfig()));
        this.requestTracer = Optional.ofNullable(builder.requestTracer).orElse(new OwnedSupplier<ThresholdRequestTracer>(ThresholdRequestTracer.create(this.eventBus.get(), this.thresholdRequestTracerConfig)));
        if (this.requestTracer instanceof OwnedSupplier) {
            this.requestTracer.get().start().block();
        }
        this.meter = Optional.ofNullable(builder.meter).orElse(new OwnedSupplier<NoopMeter>((NoopMeter)(this.aggregatingMeterConfig.enabled() ? AggregatingMeter.create(this.eventBus.get(), this.aggregatingMeterConfig) : new NoopMeter())));
        if (this.meter instanceof OwnedSupplier) {
            this.meter.get().start().block();
        }
        this.orphanReporter = new OrphanReporter(this.eventBus.get(), this.orphanReporterConfig);
        this.orphanReporter.start().block();
        if (this.ioConfig.idleHttpConnectionTimeout().toMillis() > AbstractPooledEndpointServiceConfig.DEFAULT_IDLE_TIME.toMillis()) {
            this.eventBus.get().publish(new HighIdleHttpConnectionTimeoutConfiguredEvent());
        }
        this.checkInsecureTlsConfig();
    }

    private void checkInsecureTlsConfig() {
        if (this.securityConfig.tlsEnabled()) {
            boolean validateHosts = this.securityConfig.hostnameVerificationEnabled();
            boolean insecureTrustManager = this.securityConfig.trustManagerFactory() instanceof InsecureTrustManagerFactory;
            if (!validateHosts || insecureTrustManager) {
                this.eventBus.get().publish(new InsecureSecurityConfigDetectedEvent(validateHosts, insecureTrustManager));
            }
        }
    }

    private UserAgent defaultUserAgent() {
        try {
            String os = String.join((CharSequence)" ", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
            String platform = String.join((CharSequence)" ", System.getProperty("java.vm.name"), System.getProperty("java.runtime.version"));
            return new UserAgent(this.defaultAgentTitle(), this.clientVersion(), Optional.of(os), Optional.of(platform));
        }
        catch (Throwable t) {
            return new UserAgent(this.defaultAgentTitle(), this.clientVersion(), Optional.empty(), Optional.empty());
        }
    }

    protected String defaultAgentTitle() {
        return CORE_AGENT_TITLE;
    }

    public Optional<String> clientHash() {
        return this.loadFromManifest(this.defaultAgentTitle(), "Impl-Git-Revision");
    }

    public Optional<String> coreHash() {
        return this.loadFromManifest(CORE_AGENT_TITLE, "Impl-Git-Revision");
    }

    public Optional<String> clientVersion() {
        return this.loadFromManifest(this.defaultAgentTitle(), "Impl-Version");
    }

    public Optional<String> coreVersion() {
        return this.loadFromManifest(CORE_AGENT_TITLE, "Impl-Version");
    }

    private Optional<String> loadFromManifest(String agent, String value) {
        Attributes attributes = MANIFEST_INFOS.get("couchbase-" + agent);
        if (attributes == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(attributes.getValue(value));
    }

    public UserAgent userAgent() {
        return this.userAgent;
    }

    public EventBus eventBus() {
        return this.eventBus.get();
    }

    public IoEnvironment ioEnvironment() {
        return this.ioEnvironment;
    }

    public IoConfig ioConfig() {
        return this.ioConfig;
    }

    public TimeoutConfig timeoutConfig() {
        return this.timeoutConfig;
    }

    public SecurityConfig securityConfig() {
        return this.securityConfig;
    }

    public CompressionConfig compressionConfig() {
        return this.compressionConfig;
    }

    public LoggerConfig loggerConfig() {
        return this.loggerConfig;
    }

    public Scheduler scheduler() {
        return this.scheduler.get();
    }

    @Stability.Volatile
    public RequestTracer requestTracer() {
        return this.requestTracer.get();
    }

    @Stability.Volatile
    public Meter meter() {
        return this.meter.get();
    }

    public Timer timer() {
        return this.timer;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public OrphanReporter orphanReporter() {
        return this.orphanReporter;
    }

    public CompletableFuture<Void> shutdownAsync() {
        return this.shutdownAsync(this.timeoutConfig.disconnectTimeout());
    }

    public CompletableFuture<Void> shutdownAsync(Duration timeout) {
        return this.shutdownReactive(timeout).toFuture();
    }

    public Mono<Void> shutdownReactive() {
        return this.shutdownReactive(this.timeoutConfig.disconnectTimeout());
    }

    public Mono<Void> shutdownReactive(Duration timeout) {
        return Mono.defer(() -> this.eventBus instanceof OwnedSupplier ? this.eventBus.get().stop(timeout) : Mono.empty()).then(Mono.defer(() -> {
            this.timer.stop();
            return Mono.empty();
        })).then(this.ioEnvironment.shutdown(timeout)).then(Mono.defer(() -> {
            if (this.requestTracer instanceof OwnedSupplier) {
                return this.requestTracer.get().stop(timeout);
            }
            return Mono.empty();
        })).then(Mono.defer(this.orphanReporter::stop)).then(Mono.defer(() -> {
            if (this.scheduler instanceof OwnedSupplier) {
                this.scheduler.get().dispose();
            }
            return Mono.empty();
        })).then().timeout(timeout);
    }

    public void shutdown(Duration timeout) {
        this.shutdownReactive(timeout).block();
    }

    public void shutdown() {
        this.shutdown(this.timeoutConfig.disconnectTimeout());
    }

    public String exportAsString(Context.ExportFormat format) {
        LinkedHashMap<String, Object> input = new LinkedHashMap<String, Object>();
        input.put("clientVersion", this.clientVersion().orElse(null));
        input.put("clientGitHash", this.clientHash().orElse(null));
        input.put("coreVersion", this.coreVersion().orElse(null));
        input.put("coreGitHash", this.coreHash().orElse(null));
        input.put("userAgent", this.userAgent.formattedLong());
        input.put("maxNumRequestsInRetry", this.maxNumRequestsInRetry);
        input.put("ioEnvironment", this.ioEnvironment.exportAsMap());
        input.put("ioConfig", this.ioConfig.exportAsMap());
        input.put("compressionConfig", this.compressionConfig.exportAsMap());
        input.put("securityConfig", this.securityConfig.exportAsMap());
        input.put("timeoutConfig", this.timeoutConfig.exportAsMap());
        input.put("loggerConfig", this.loggerConfig.exportAsMap());
        input.put("orphanReporterConfig", this.orphanReporterConfig.exportAsMap());
        input.put("thresholdRequestTracerConfig", this.thresholdRequestTracerConfig.exportAsMap());
        input.put("aggregatingMeterConfig", this.aggregatingMeterConfig.exportAsMap());
        input.put("retryStrategy", this.retryStrategy.getClass().getSimpleName());
        input.put("requestTracer", this.requestTracer.get().getClass().getSimpleName());
        input.put("meter", this.meter.get().getClass().getSimpleName());
        return (String)format.apply(input);
    }

    public String toString() {
        return this.exportAsString(Context.ExportFormat.STRING);
    }

    static {
        try {
            Enumeration<URL> resources = CoreEnvironment.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                Manifest manifest;
                URL manifestUrl = resources.nextElement();
                if (manifestUrl == null || (manifest = new Manifest(manifestUrl.openStream())).getEntries() == null) continue;
                for (Map.Entry<String, Attributes> entry : manifest.getEntries().entrySet()) {
                    if (!entry.getKey().startsWith("couchbase-")) continue;
                    MANIFEST_INFOS.put(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFAULT_RETRY_STRATEGY = BestEffortRetryStrategy.INSTANCE;
    }

    public static class Builder<SELF extends Builder<SELF>> {
        private IoEnvironment.Builder ioEnvironment = IoEnvironment.builder();
        private IoConfig.Builder ioConfig = IoConfig.builder();
        private CompressionConfig.Builder compressionConfig = CompressionConfig.builder();
        private SecurityConfig.Builder securityConfig = SecurityConfig.builder();
        private TimeoutConfig.Builder timeoutConfig = TimeoutConfig.builder();
        private LoggerConfig.Builder loggerConfig = LoggerConfig.builder();
        private OrphanReporterConfig.Builder orphanReporterConfig = OrphanReporterConfig.builder();
        private ThresholdRequestTracerConfig.Builder thresholdRequestTracerConfig = ThresholdRequestTracerConfig.builder();
        private AggregatingMeterConfig.Builder aggregatingMeterConfig = AggregatingMeterConfig.builder();
        private Supplier<EventBus> eventBus = null;
        private Supplier<Scheduler> scheduler = null;
        private Supplier<RequestTracer> requestTracer = null;
        private Supplier<Meter> meter = null;
        private RetryStrategy retryStrategy = null;
        private long maxNumRequestsInRetry = 32768L;

        protected Builder() {
        }

        protected SELF self() {
            return (SELF)this;
        }

        public SELF maxNumRequestsInRetry(long maxNumRequestsInRetry) {
            if (maxNumRequestsInRetry < 0L) {
                throw InvalidArgumentException.fromMessage("maxNumRequestsInRetry cannot be negative");
            }
            this.maxNumRequestsInRetry = maxNumRequestsInRetry;
            return this.self();
        }

        public SELF load(PropertyLoader<Builder> loader) {
            Validators.notNull(loader, "PropertyLoader");
            loader.load(this);
            return this.self();
        }

        public SELF ioEnvironment(IoEnvironment.Builder ioEnvironment) {
            this.ioEnvironment = Validators.notNull(ioEnvironment, "IoEnvironment");
            return this.self();
        }

        public SELF ioConfig(IoConfig.Builder ioConfig) {
            this.ioConfig = Validators.notNull(ioConfig, "IoConfig");
            return this.self();
        }

        public IoConfig.Builder ioConfig() {
            return this.ioConfig;
        }

        public SELF orphanReporterConfig(OrphanReporterConfig.Builder orphanReporterConfig) {
            this.orphanReporterConfig = Validators.notNull(orphanReporterConfig, "OrphanReporterConfig");
            return this.self();
        }

        public OrphanReporterConfig.Builder orphanReporterConfig() {
            return this.orphanReporterConfig;
        }

        public SELF aggregatingMeterConfig(AggregatingMeterConfig.Builder aggregatingMeterConfig) {
            this.aggregatingMeterConfig = Validators.notNull(aggregatingMeterConfig, "AggregatingMeterConfig");
            return this.self();
        }

        public AggregatingMeterConfig.Builder aggregatingMeterConfig() {
            return this.aggregatingMeterConfig;
        }

        public SELF thresholdRequestTracerConfig(ThresholdRequestTracerConfig.Builder thresholdRequestTracerConfig) {
            this.thresholdRequestTracerConfig = Validators.notNull(thresholdRequestTracerConfig, "ThresholdRequestTracerConfig");
            return this.self();
        }

        public ThresholdRequestTracerConfig.Builder thresholdRequestTracerConfig() {
            return this.thresholdRequestTracerConfig;
        }

        public SELF compressionConfig(CompressionConfig.Builder compressionConfig) {
            this.compressionConfig = Validators.notNull(compressionConfig, "CompressionConfig");
            return this.self();
        }

        public CompressionConfig.Builder compressionConfig() {
            return this.compressionConfig;
        }

        public SELF securityConfig(SecurityConfig.Builder securityConfig) {
            this.securityConfig = Validators.notNull(securityConfig, "SecurityConfig");
            return this.self();
        }

        public SecurityConfig.Builder securityConfig() {
            return this.securityConfig;
        }

        public SELF timeoutConfig(TimeoutConfig.Builder timeoutConfig) {
            this.timeoutConfig = Validators.notNull(timeoutConfig, "TimeoutConfig");
            return this.self();
        }

        public TimeoutConfig.Builder timeoutConfig() {
            return this.timeoutConfig;
        }

        public SELF loggerConfig(LoggerConfig.Builder loggerConfig) {
            this.loggerConfig = Validators.notNull(loggerConfig, "LoggerConfig");
            return this.self();
        }

        public LoggerConfig.Builder loggerConfig() {
            return this.loggerConfig;
        }

        @Stability.Uncommitted
        public SELF eventBus(EventBus eventBus) {
            this.eventBus = new ExternalSupplier<EventBus>(Validators.notNull(eventBus, "EventBus"));
            return this.self();
        }

        @Stability.Uncommitted
        public SELF scheduler(Scheduler scheduler) {
            this.scheduler = new ExternalSupplier<Scheduler>(Validators.notNull(scheduler, "Scheduler"));
            return this.self();
        }

        public SELF retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = Validators.notNull(retryStrategy, "RetryStrategy");
            return this.self();
        }

        @Stability.Volatile
        public SELF requestTracer(RequestTracer requestTracer) {
            this.requestTracer = new ExternalSupplier<RequestTracer>(Validators.notNull(requestTracer, "RequestTracer"));
            return this.self();
        }

        @Stability.Volatile
        public SELF meter(Meter meter) {
            this.meter = new ExternalSupplier<Meter>(Validators.notNull(meter, "Meter"));
            return this.self();
        }

        public CoreEnvironment build() {
            return new CoreEnvironment(this);
        }
    }
}

